% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sequential.R
\name{sequential}
\alias{sequential}
\alias{uniprocess}
\alias{transparent}
\title{Create a sequential future whose value will be in the current \R session}
\usage{
sequential(..., envir = parent.frame())

transparent(..., envir = parent.frame())
}
\arguments{
\item{...}{Additional arguments passed to \code{\link[=Future]{Future()}}.}

\item{envir}{The \link{environment} from where global objects should be
identified.}
}
\value{
A \link{SequentialFuture}.
}
\description{
A sequential future is a future that is evaluated sequentially in the
current \R session similarly to how \R expressions are evaluated in \R.
The only difference to \R itself is that globals are validated
by default just as for all other types of futures in this package.
}
\details{
This function is \emph{not} meant to be called directly.  Instead, the
typical usages are:\if{html}{\out{<div class="sourceCode r">}}\preformatted{# Evaluate futures sequentially in the current R process
plan(sequential)
}\if{html}{\out{</div>}}


}
\section{transparent futures (troubleshooting only)}{

Transparent futures are sequential futures configured to emulate how R
evaluates expressions as far as possible.  For instance, errors and
warnings are signaled immediately and assignments are done to the
calling environment (without \code{local()} as default for all other
types of futures).  This makes transparent futures useful for
troubleshooting, especially when there are errors.  Having said that,
using:\if{html}{\out{<div class="sourceCode r">}}\preformatted{plan(sequential, split = TRUE)
}\if{html}{\out{</div>}}

together with \code{debug()} is often sufficient for troubleshooting.

\emph{WARNING: Transparent futures should only be used for debugging and
troubleshooting.  They should not be used for production pipelines
and must not be set within another package.  This is especially
important since 'transparent' futures might be deprecated and replaced
by better means of debugging in future releases.}
}

\examples{
## Use sequential futures
plan(sequential)

## A global variable
a <- 0

## Create a sequential future
f <- future({
  b <- 3
  c <- 2
  a * b * c
})

## Since 'a' is a global variable in future 'f' which
## is eagerly resolved (default), this global has already
## been resolved / incorporated, and any changes to 'a'
## at this point will _not_ affect the value of 'f'.
a <- 7
print(a)

v <- value(f)
print(v)
stopifnot(v == 0)
}
