% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/UniprocessFuture-class.R
\name{UniprocessFuture-class}
\alias{UniprocessFuture-class}
\alias{UniprocessFuture}
\alias{SequentialFuture}
\alias{EagerFuture}
\alias{LazyFuture}
\title{An uniprocess future is a future whose value will be resolved synchronously in the current process}
\usage{
UniprocessFuture(expr = NULL, envir = parent.frame(), substitute = FALSE,
  lazy = FALSE, globals = TRUE, local = TRUE, ...)

SequentialFuture(expr = NULL, envir = parent.frame(), substitute = FALSE,
  lazy = FALSE, globals = TRUE, local = TRUE, ...)

EagerFuture(expr = NULL, envir = parent.frame(), substitute = FALSE,
  lazy = FALSE, globals = TRUE, local = TRUE, ...)

LazyFuture(expr = NULL, envir = parent.frame(), substitute = FALSE,
  lazy = TRUE, globals = TRUE, local = TRUE, ...)
}
\arguments{
\item{expr}{An R \link[base]{expression}.}

\item{envir}{The \link{environment} in which the evaluation
is done (or inherits from if \code{local} is TRUE).}

\item{substitute}{If TRUE, argument \code{expr} is
\code{\link[base]{substitute}()}:ed, otherwise not.}

\item{lazy}{If \code{FALSE} (default), then the setup and validation of
global variables are done for eager evaluation, otherwise not.}

\item{local}{If TRUE, the expression is evaluated such that
all assignments are done to local temporary environment, otherwise
the assignments are done in the calling environment.}

\item{\dots}{Additional named elements passed to \code{\link{Future}()}.}
}
\value{
An object of class \code{UniprocessFuture}.
}
\description{
An uniprocess future is a future whose value will be resolved synchronously in the current process
}
\seealso{
To evaluate an expression using "uniprocess future", see functions
\code{\link{uniprocess}()}.
}
\keyword{internal}
