% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/processHeatwaves.R
\name{formHwFrame}
\alias{formHwFrame}
\title{Create heat wave dataframe for an ensemble}
\usage{
formHwFrame(ensembleSeries, thresholds, global, custom)
}
\arguments{
\item{ensembleSeries}{A list object giving the projection time series as
well as a variety of other information for a single ensemble member.
This is the output of \code{\link{processEnsemble}}.}

\item{thresholds}{A vector with the thresholds to use within each city
in that city's heat wave definition.These are typically automatically
determine during the run of the \code{gen_hw_set} function.}

\item{global}{An list object created by \code{\link{gen_hw_set}} that
includes user specifications (e.g., the path to the output directory, the
path to the input climate projections, the dataframe with city
locations).}

\item{custom}{An list object created by \code{\link{gen_hw_set}} that
includes user specifications (e.g., the name of the R function to
use to identify heat waves, alternative upper and lower year boundaries
for the data used to determine threshold temperatures for the heat wave
definition, alternative upper and lower year boundaries
for the projection period of the heat wave datasets being generated).}
}
\value{
The combined dataframe of identified and characterized heat waves for
   selected projection date range for all cities specified by the user.
   This dataframe includes the following columns:
\itemize{
   \item hw.number: A sequential number identifying each heat wave in a city;
   \item mean.temp: Average daily temperature across all days in the
      heat wave, in degrees Fahrenheit;
   \item max.temp: Highest daily temperature across days in the
      heat wave, in degrees Fahrenheit;
   \item min.temp: Lowest daily temperature across days in the
      heat wave, in degrees Fahrenheit
   \item length: Number of days in the heat wave;
   \item start.date: Date of the first day of the heat wave;
   \item end.date: Date of the last day of the heat wave;
   \item start.doy: Day of the year of the first day of the heat wave
      (1 = Jan. 1, etc.);
   \item start.month: Month in which the heat wave started (1 = January,
      etc.);
   \item days.above.80: Number of days in the heat wave above 80 degrees
       Fahrenheit;
   \item days.above.85: Number of days in the heat wave above 85 degrees
       Fahrenheit;
   \item days.above.90: Number of days in the heat wave above 90 degrees
       Fahrenheit;
   \item days.above.95: Number of days in the heat wave above 90 degrees
       Fahrenheit;
   \item days.above.99th: Number of days in the heat wave above the 99th
       percentile temperature for the city, using the period specified
       by the user with the \code{referenceBoundaries} argument in
       \code{\link{gen_hw_set}} as a reference for determining these
       percentiles;
   \item days.above.99.5th: Number of days in the heat wave above the 99.5th
       percentile temperature for the city, using the period specified
       by the user with the \code{referenceBoundaries} argument in
       \code{\link{gen_hw_set}} as a reference for determining these
       percentiles;
   \item first.in.season: Whether the heat wave was the first to occur in its
       calendar year (Note: this characteristic is likely not useful in
       southern hemisphere studies.);
   \item threshold.temp: The temperature used as the threshold for the
       heat wave definition in the city;
   \item mean.temp.quantile: The percentile of the average daily mean
       temperature during the heat wave compared to the city's year-round
       temperature distribution, based on the temperatures for the city
       during the period specified by the \code{referenceBoundaries}
       argument in \code{\link{gen_hw_set}};
   \item max.temp.quantile: The percentile of the highest daily mean
       temperature during the heat wave compared to the city's year-round
       temperature distribution;
   \item min.temp.quantile: The percentile of the lowest daily mean
       temperature during the heat wave compared to the city's year-round
       temperature distribution;
   \item mean.temp.1: The city's average year-round temperature, based
       on the temperatures for the city during the period specified by
       the \code{referenceBoundaries} argument in
       \code{\link{gen_hw_set}};
   \item mean.summer.temp: The city's average May--September
       temperature, based on the temperatures for the city during the
       period specified by the \code{referenceBoundaries} argument
       in \code{\link{gen_hw_set}}; and
   \item city: The identifier for the city, as given in the file
       specified in the \code{citycsv} argument of
       \code{\link{gen_hw_set}}.
}
An example of the output of this function is available as the
\code{\link{hw_datafr}} dataset and can be accessed using
\code{data(hw_datafr)}.
}
\description{
This function takes inputs, from \code{\link{processProjections}}, on the
projection data for an ensemble member, the thresholds for cities for
the ensemble, and \code{global} and \code{custom} objects with user
specifications. Using these inputs, the function creates a dataframe with
heat waves identified and characterized for the ensemble member.
}

