\docType{data}
\name{FIS_IMP}
\alias{FIS_IMP}
\title{Fuzzy Inference System 1 (FIS1)}
\format{frbs object}
\description{
Fuzzy Inference System used in the Initial Map Matching
Process (IMP).
}
\details{
The IMP is the first and very important part of the map
matching process since it is responsible for the
identification of the initial link. Here you can see the
input variables, fuzzy subsets and fuzzy rules used in
FIS1. It is usefull to know the variables and how they
affect the rule outputs in case you plan to change the
range of the fuzzy subsets.

Input variables to this FIS are: \itemize{ \item speed of
the vehicle, v (m/s) \item heading error, HE (degrees)
\item perpendicular distance to candidate link, PD (m)
\item horizontal dilution of precision (HDOP) }

The fuzzy subsets of the input variables are: \itemize{
\item high, low, zero \item small, large \item short, long
\item good, bad }

The corresponding fuzzy rules used in this FIS are:
\itemize{ \item If ( v is high) and (HE is small) then (L1
is average) \item If (v is high) and (HE is large) then (L1
is low) \item If (HDOP is good) and (PD is short) then (L1
is average) \item If (HDOP is good) and (PD is long) then
(L1 is low) \item If ( HE is small) and (PD is short) then
( L1 is high) \item If ( HE is large) and ( PD is long)
then (L1 is low) }
}
\examples{
fis_imp <- get_fis("IMP")
fis_imp
# Plot membership functions
plotMF(fis_imp)
}
\seealso{
\link{get_var_bounds}, \link{set_var_bounds}
}
\keyword{datasets}

