/*
 * Decompiled with CFR 0.152.
 */
package org.af.gMCP.gui.graph;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.af.commons.widgets.DesktopPaneBG;
import org.af.gMCP.config.Configuration;
import org.af.gMCP.gui.CreateGraphGUI;
import org.af.gMCP.gui.RControl;
import org.af.gMCP.gui.graph.Node;
import org.af.gMCP.gui.graph.PPanel;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PView
extends JPanel
implements KeyListener,
ActionListener {
    private static final Log logger = LogFactory.getLog(PView.class);
    private Vector<PPanel> panels = new Vector();
    CellConstraints cc = new CellConstraints();
    JLabel statusLabel = new JLabel("");
    JLabel weightLabel = new JLabel("Weight");
    JLabel alphaLabel = new JLabel("Total \u03b1: ");
    JTextField totalAlpha = new JTextField("0.05");
    GridBagConstraints c = new GridBagConstraints();
    CreateGraphGUI parent;
    List<Double> pValues = null;
    JButton refresh;
    protected JRadioButton jrbNoCorrelation = new JRadioButton("No Information about correlations");
    protected JRadioButton jrbStandardCorrelation = new JRadioButton("Select a standard correlation");
    protected JRadioButton jrbRCorrelation = new JRadioButton("Select an R correlation matrix");
    protected JComboBox jcbCorString;
    protected JComboBox jcbCorObject;
    JPanel correlatedPanel = null;

    public PView(CreateGraphGUI parent) {
        this.parent = parent;
        this.setLayout(new GridBagLayout());
        this.c.weightx = 1.0;
        this.c.weighty = 1.0;
        this.c.fill = 1;
        this.c.gridx = 0;
        this.c.gridy = 0;
        this.c.gridwidth = 1;
        this.c.gridheight = 1;
        this.c.ipadx = 0;
        this.c.ipady = 0;
        this.totalAlpha.addKeyListener(this);
        this.setUp();
    }

    public void addPPanel(Node node) {
        this.panels.add(new PPanel(node, this));
        logger.debug((Object)("Added panel for node " + node.getName()));
        this.setUp();
    }

    public void savePValues() {
        String debug = "Saving : ";
        this.pValues = new Vector<Double>();
        for (PPanel panel : this.panels) {
            this.pValues.add(panel.getP());
            debug = debug + Configuration.getInstance().getGeneralConfig().getDecFormat().format(panel.getP()) + "; ";
        }
        logger.debug((Object)debug);
    }

    public void setPValues(Double[] pvalues) {
        this.pValues = Arrays.asList(pvalues);
        this.restorePValues();
    }

    public void setPValues(double[] pvalues) {
        this.setPValues(ArrayUtils.toObject((double[])pvalues));
    }

    public void restorePValues() {
        String debug = "Restoring : ";
        if (this.pValues != null) {
            for (int i = 0; i < this.pValues.size(); ++i) {
                if (i >= this.panels.size()) continue;
                this.panels.get(i).setP(this.pValues.get(i));
                debug = debug + Configuration.getInstance().getGeneralConfig().getDecFormat().format(this.pValues.get(i)) + "; ";
            }
        }
        logger.debug((Object)debug);
    }

    public void setUp() {
        JPanel panel = new JPanel();
        String cols = "5dlu, fill:pref:grow, 5dlu, fill:pref:grow, 5dlu, fill:pref:grow, 5dlu, fill:pref:grow, 5dlu";
        String rows = "5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu";
        for (PPanel p : this.panels) {
            rows = rows + ", pref, 5dlu";
        }
        FormLayout layout = new FormLayout(cols, rows);
        panel.setLayout((LayoutManager)layout);
        panel.add((Component)new JLabel("Hypothesis"), this.cc.xy(2, 2));
        panel.add((Component)this.weightLabel, this.cc.xy(4, 2));
        panel.add((Component)new JLabel("P-Value"), this.cc.xy(6, 2));
        int row = 4;
        for (PPanel p : this.panels) {
            int col = 2;
            for (Component c : p.getComponent()) {
                panel.add(c, this.cc.xy(col, row));
                col += 2;
            }
            row += 2;
        }
        panel.add((Component)this.statusLabel, this.cc.xyw(2, row, 7));
        panel.add((Component)this.alphaLabel, this.cc.xy(2, row += 2));
        panel.add((Component)this.totalAlpha, this.cc.xy(4, row));
        this.updateLabels();
        panel.revalidate();
        this.removeAll();
        this.add((Component)panel, this.c);
        ++this.c.gridy;
        this.add((Component)this.getCorrelatedPanel(), this.c);
        this.revalidate();
    }

    public void updateLabels() {
        double weight = 0.0;
        for (PPanel p : this.panels) {
            if (p.rejected.booleanValue()) continue;
            weight += p.w;
        }
        String text = "Sum of weights: " + Configuration.getInstance().getGeneralConfig().getDecFormat().format(weight);
        if (weight > 1.0001) {
            this.statusLabel.setForeground(Color.RED);
            text = text + "; The total weight is greater 1!";
        } else {
            this.statusLabel.setForeground(Color.BLACK);
        }
        this.statusLabel.setText(text);
    }

    public void recalculate() {
        for (PPanel p : this.panels) {
            p.updateMe(true);
        }
        this.revalidate();
        this.repaint();
    }

    public void newGraph() {
        this.panels.removeAllElements();
    }

    public void removePPanel(Node node) {
        for (int i = this.panels.size() - 1; i >= 0; --i) {
            if (this.panels.get((int)i).node != node) continue;
            this.panels.remove(i);
            logger.debug((Object)("Removed panel for node " + node.getName()));
        }
        this.setUp();
    }

    public void setTesting(boolean b) {
        PPanel.setTesting(b);
        for (PPanel p : this.panels) {
            p.updateMe(true);
        }
        this.totalAlpha.setEditable(!b);
        if (b) {
            this.weightLabel.setText("\u03b1 Level");
        } else {
            this.weightLabel.setText("Weight");
        }
    }

    public String getPValuesString() {
        this.savePValues();
        String s = "c(";
        for (double p : this.pValues) {
            s = s + p + ", ";
        }
        return s.substring(0, s.length() - 2) + ")";
    }

    public double getPValue(Node node) {
        for (int i = this.panels.size() - 1; i >= 0; --i) {
            if (this.panels.get((int)i).node != node) continue;
            return this.panels.get((int)i).p;
        }
        throw new RuntimeException("Something happend that should never happen. Please report!");
    }

    public double getTotalAlpha() {
        return Double.parseDouble(this.totalAlpha.getText());
    }

    public void keyPressed(KeyEvent e) {
        this.keyTyped(e);
    }

    public void keyReleased(KeyEvent e) {
        this.keyTyped(e);
    }

    public void keyTyped(KeyEvent e) {
        for (PPanel p : this.panels) {
            p.updateMe(false);
        }
    }

    public JPanel getCorrelatedPanel() {
        if (this.correlatedPanel != null) {
            return this.correlatedPanel;
        }
        try {
            this.refresh = new JButton(new ImageIcon(ImageIO.read(DesktopPaneBG.class.getResource("/org/af/gMCP/gui/graph/images/update24.png"))));
        }
        catch (IOException e) {
            logger.error((Object)"IOError that should never happen.", (Throwable)e);
        }
        this.refresh.setToolTipText("search again for matrices in R");
        this.correlatedPanel = new JPanel();
        String[] matrices = RControl.getR().eval("gMCP:::getAllQuadraticMatrices()").asRChar().getData();
        String[] correlations = new String[]{"Dunnett"};
        this.jcbCorString = new JComboBox<String>(correlations);
        this.jcbCorObject = new JComboBox<String>(matrices);
        if (matrices.length == 1 && matrices[0].equals("No quadratic matrices found.")) {
            this.jcbCorObject.setEnabled(false);
            this.jrbRCorrelation.setEnabled(false);
        }
        this.jrbNoCorrelation.setSelected(true);
        ButtonGroup group = new ButtonGroup();
        group.add(this.jrbNoCorrelation);
        group.add(this.jrbStandardCorrelation);
        group.add(this.jrbRCorrelation);
        this.jrbNoCorrelation.addActionListener(this);
        this.jrbStandardCorrelation.addActionListener(this);
        this.jrbRCorrelation.addActionListener(this);
        String cols = "5dlu, pref, 5dlu, fill:pref:grow, 5dlu, pref, 5dlu";
        String rows = "5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu";
        FormLayout layout = new FormLayout(cols, rows);
        this.correlatedPanel.setLayout((LayoutManager)layout);
        CellConstraints cc = new CellConstraints();
        int row = 2;
        this.correlatedPanel.add((Component)this.jrbNoCorrelation, cc.xy(2, row));
        this.correlatedPanel.add((Component)this.jrbStandardCorrelation, cc.xy(2, row += 2));
        this.correlatedPanel.add((Component)this.jcbCorString, cc.xy(4, row));
        this.correlatedPanel.add((Component)this.jrbRCorrelation, cc.xy(2, row += 2));
        this.correlatedPanel.add((Component)this.jcbCorObject, cc.xy(4, row));
        this.correlatedPanel.add((Component)this.refresh, cc.xy(6, row));
        this.refresh.addActionListener(this);
        return this.correlatedPanel;
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.refresh) {
            this.jcbCorObject.removeAllItems();
            String[] matrices = RControl.getR().eval("gMCP:::getAllQuadraticMatrices()").asRChar().getData();
            if (matrices.length == 1 && matrices[0].equals("No quadratic matrices found.")) {
                this.jcbCorObject.setEnabled(false);
                this.jrbRCorrelation.setEnabled(false);
            } else {
                this.jcbCorObject.setEnabled(true);
                this.jrbRCorrelation.setEnabled(true);
            }
            for (String s : matrices) {
                this.jcbCorObject.addItem(s);
            }
        } else if (e.getSource() == this.jrbNoCorrelation) {
            if (this.parent.getGraphView().getNL().getKnoten().size() > 0) {
                this.parent.getGraphView().buttonConfInt.setEnabled(true);
            }
        } else if (e.getSource() == this.jrbStandardCorrelation || e.getSource() == this.jrbRCorrelation) {
            this.parent.getGraphView().buttonConfInt.setEnabled(false);
        }
    }

    public String getCorrelation() {
        String correlation = "";
        if (this.jrbStandardCorrelation.isSelected()) {
            correlation = ", correlation=\"" + this.jcbCorString.getSelectedItem() + "\"";
        } else if (this.jrbRCorrelation.isSelected()) {
            correlation = ", correlation=" + this.jcbCorObject.getSelectedItem() + "";
        }
        return correlation;
    }
}

