/*
 * Decompiled with CFR 0.152.
 */
package org.af.gMCP.gui.dialogs;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.af.commons.widgets.buttons.OkCancelButtonPane;
import org.af.gMCP.config.Configuration;
import org.af.gMCP.gui.CreateGraphGUI;
import org.af.gMCP.gui.RControl;
import org.af.gMCP.gui.datatable.CellEditorE;
import org.af.gMCP.gui.datatable.RDataFrameRef;
import org.af.gMCP.gui.datatable.SingleDataFramePanel;
import org.af.gMCP.gui.dialogs.MatrixCreationDialog;
import org.af.gMCP.gui.dialogs.PowerParameterPanel;
import org.af.gMCP.gui.dialogs.TextFileViewer;
import org.af.gMCP.gui.dialogs.VariableNameDialog;
import org.af.gMCP.gui.graph.EdgeWeight;
import org.af.gMCP.gui.graph.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PowerDialogParameterUncertainty
extends JDialog
implements ActionListener {
    JButton addAnother = new JButton("Add another power function");
    List<JButton> buttons = new Vector<JButton>();
    List<JButton> buttons2 = new Vector<JButton>();
    SingleDataFramePanel dfp;
    SingleDataFramePanel dfp2;
    JTextArea jta = new JTextArea();
    List<JTextField> jtl;
    List<JTextField> jtlMu;
    List<JTextField> jtlN;
    List<JTextField> jtlSigma;
    List<JTextField> jtlVar = new Vector<JTextField>();
    JTextField jtUserDefined = new JTextField();
    DefaultListModel listModel;
    JButton loadUDPF = new JButton("Load");
    JButton saveUDPF = new JButton("Save");
    JList listUserDefined;
    JCheckBox secondCV = new JCheckBox("Use another matrix for the parametric test (misspecified or contains NA values)");
    JButton loadCV = new JButton("Load Matrix from R");
    JButton createCV = new JButton("Advanced Matrix Creation");
    JButton loadCV2 = new JButton("Load Matrix from R");
    JButton createCV2 = new JButton("Advanced Matrix Creation");
    JButton clearList = new JButton("Clear");
    boolean ncp = true;
    Vector<Node> nodes;
    private JComboBox numberOfSettings = new JComboBox<String>(new String[]{"Single setting", "Multiple settings"});
    CreateGraphGUI parent;
    PowerParameterPanel pPanelMeans;
    PowerParameterPanel pPanelSigmas;
    PowerParameterPanel pPanelN;
    JPanel panel2 = new JPanel();
    JPanel panelOne = new JPanel();
    JPanel panelMany = new JPanel();
    JPanel panel = new JPanel();
    JPanel singleMuSigmaN = new JPanel();
    JPanel singleNCP = new JPanel();
    JButton switchNCP = new JButton("Enter \u00b5, \u03c3 and n instead of ncp");
    JTabbedPane tPanel = new JTabbedPane();
    Object[] variables;

    public static GridBagConstraints getDefaultGridBagConstraints() {
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.ipadx = 10;
        c.ipady = 10;
        c.weightx = 1.0;
        c.weighty = 1.0;
        return c;
    }

    public PowerDialogParameterUncertainty(CreateGraphGUI parent) {
        super(parent, "Power Simulation - specify probability distribution of test statistics", true);
        this.setLocationRelativeTo(parent);
        this.parent = parent;
        this.nodes = parent.getGraphView().getNL().getNodes();
        RDataFrameRef df = new RDataFrameRef();
        RDataFrameRef df2 = new RDataFrameRef();
        for (Node n : this.nodes) {
            df.addRowCol(n.getName());
            df2.addRowCol(n.getName());
            df.setValue(df.getColumnCount() - 1, df.getColumnCount() - 1, new EdgeWeight(1.0));
            df2.setValue(df2.getColumnCount() - 1, df2.getColumnCount() - 1, new EdgeWeight(1.0));
        }
        this.dfp = new SingleDataFramePanel(df);
        this.dfp.getTable().getModel().diagEditable = true;
        this.dfp.getTable().setDefaultEditor(EdgeWeight.class, new CellEditorE(null, this.dfp.getTable()));
        this.dfp.getTable().getModel().setCheckRowSum(false);
        this.dfp2 = new SingleDataFramePanel(df);
        this.dfp2.getTable().getModel().diagEditable = true;
        this.dfp2.getTable().setDefaultEditor(EdgeWeight.class, new CellEditorE(null, this.dfp.getTable()));
        this.dfp2.getTable().getModel().setCheckRowSum(false);
        this.dfp2.setEnabled(false);
        if (parent.getPView().jrbRCorrelation.isSelected()) {
            String name = parent.getPView().jcbCorObject.getSelectedItem().toString();
            try {
                double[] result = RControl.getR().eval("as.numeric(" + name + ")").asRNumeric().getData();
                int n = this.nodes.size();
                for (int i = 0; i < n; ++i) {
                    for (int j = 0; j < n; ++j) {
                        this.dfp.getTable().getModel().setValueAt(new EdgeWeight(result[i * n + j]), i, j);
                        this.dfp2.getTable().getModel().setValueAt(new EdgeWeight(result[i * n + j]), i, j);
                    }
                }
            }
            catch (Exception exc) {
                JOptionPane.showMessageDialog(this, "Could not load matrix \"" + name + "\":\n" + exc.getMessage(), "Could not load matrix", 0);
            }
        }
        parent.getPView().getParameters();
        GridBagConstraints c = PowerDialogParameterUncertainty.getDefaultGridBagConstraints();
        this.getContentPane().setLayout(new GridBagLayout());
        this.tPanel.addTab("NCP Settings", this.getSettingPanel());
        this.tPanel.addTab("Covariance Matrix", this.getCVPanel());
        this.tPanel.addTab("User defined power function", this.getUserDefinedFunctions());
        Set<String> variables = parent.getGraphView().getNL().getAllVariables();
        if (!Configuration.getInstance().getGeneralConfig().useEpsApprox()) {
            variables.remove("\u03b5");
        }
        if (variables.size() > 0) {
            this.tPanel.addTab("Variables", this.getVariablePanel(variables));
        }
        this.getContentPane().add((Component)this.tPanel, c);
        c.weighty = 0.0;
        ++c.gridy;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        OkCancelButtonPane bp = new OkCancelButtonPane();
        this.getContentPane().add((Component)bp, c);
        bp.addActionListener((ActionListener)this);
        this.pack();
        this.setLocationRelativeTo(parent);
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.clearList) {
            this.listModel.removeAllElements();
            return;
        }
        if (e.getSource() == this.numberOfSettings) {
            this.panel2.removeAll();
            GridBagConstraints c = PowerDialogParameterUncertainty.getDefaultGridBagConstraints();
            if (this.numberOfSettings.getSelectedIndex() == 0) {
                this.panel2.add((Component)this.panelOne, c);
            } else {
                this.panel2.add((Component)this.panelMany, c);
            }
            Configuration.getInstance().setClassProperty(this.getClass(), "singleSetting", "" + (this.numberOfSettings.getSelectedIndex() == 0));
            this.panel2.revalidate();
            this.panel2.repaint();
            return;
        }
        if (e.getSource() == this.secondCV) {
            this.dfp2.setEnabled(this.secondCV.isSelected());
            this.loadCV2.setEnabled(this.secondCV.isSelected());
            this.createCV2.setEnabled(this.secondCV.isSelected());
            return;
        }
        if (e.getSource() == this.createCV) {
            MatrixCreationDialog mcd = new MatrixCreationDialog(this.parent, this.dfp.getTable().getRMatrix(), MatrixCreationDialog.getNames(this.parent.getGraphView().getNL().getNodes()));
            this.dfp.getTable().getModel().copy(mcd.dfp.getTable().getModel());
            return;
        }
        if (e.getSource() == this.createCV2) {
            MatrixCreationDialog mcd = new MatrixCreationDialog(this.parent, this.dfp2.getTable().getRMatrix(), MatrixCreationDialog.getNames(this.parent.getGraphView().getNL().getNodes()));
            this.dfp2.getTable().getModel().copy(mcd.dfp.getTable().getModel());
            return;
        }
        if (e.getSource() == this.loadCV) {
            this.load(this.dfp);
            return;
        }
        if (e.getSource() == this.loadCV2) {
            this.load(this.dfp2);
            return;
        }
        if (this.switchNCP == e.getSource()) {
            this.panel.removeAll();
            GridBagConstraints c = PowerDialogParameterUncertainty.getDefaultGridBagConstraints();
            if (this.ncp) {
                this.switchNCP.setText("Enter ncp instead of \u00b5, \u03c3 and n");
                this.ncp = false;
                this.panel.add((Component)this.singleMuSigmaN, c);
            } else {
                this.switchNCP.setText("Enter \u00b5, \u03c3 and n instead of ncp");
                this.ncp = true;
                this.panel.add((Component)this.singleNCP, c);
            }
            Configuration.getInstance().setClassProperty(this.getClass(), "ncp", "" + this.ncp);
            this.panel.revalidate();
            this.panel.repaint();
            return;
        }
        if (this.buttons.contains(e.getSource()) || this.buttons2.contains(e.getSource())) {
            this.jtUserDefined.setText(this.jtUserDefined.getText() + " " + ((JButton)e.getSource()).getActionCommand());
            return;
        }
        if (this.jtUserDefined.getText().length() > 0) {
            this.listModel.insertElementAt(this.jtUserDefined.getText(), 0);
            this.jtUserDefined.setText("");
        }
        if (e.getSource() == this.jtUserDefined || e.getSource() == this.addAnother) {
            return;
        }
        String weights = this.parent.getGraphView().getNL().getGraphName() + "@weights";
        double alpha = this.parent.getPView().getTotalAlpha();
        String G = this.parent.getGraphView().getNL().getGraphName() + "@m";
        double[] means = new double[this.nodes.size()];
        String settings = null;
        String userDefinedF = this.getUserDefined();
        if (e.getActionCommand().equals("OK")) {
            if (this.numberOfSettings.getSelectedIndex() == 0) {
                int answer;
                for (int i = 0; i < means.length; ++i) {
                    means[i] = this.ncp ? Double.parseDouble(this.jtl.get(i).getText()) : Double.parseDouble(this.jtlMu.get(i).getText()) * Math.sqrt(Double.parseDouble(this.jtlN.get(i).getText())) / Double.parseDouble(this.jtlSigma.get(i).getText());
                }
                String mean = RControl.getRString(means);
                settings = ", mean=" + mean;
                String rCommand = "calcPower(weights=" + weights + ", alpha=" + alpha + ", G=" + G + settings + "\n" + "," + "sigma = " + this.dfp.getTable().getModel().getDataFrame().getRMatrix() + this.getMatrixForParametricTest() + "\n" + userDefinedF + ", nSim = " + Configuration.getInstance().getGeneralConfig().getNumberOfSimulations() + ", type = \"" + Configuration.getInstance().getGeneralConfig().getTypeOfRandom() + "\"" + ")";
                if (this.parent.getPView().jrbRCorrelation.isSelected() && (answer = JOptionPane.showConfirmDialog(this, "The power calculations for parametric tests take a lot of time.\nIf you select 'yes' the GUI will run the following command:\n" + rCommand + "\n The GUI will be unresponsive during this time. Continue?", "Parametric tests take a lot of time", 0)) == 1) {
                    return;
                }
                RControl.getR().eval(".powerResult <- " + rCommand);
                double[] localPower = RControl.getR().eval(".powerResult$LocalPower").asRNumeric().getData();
                double expRejections = RControl.getR().eval(".powerResult$ExpRejections").asRNumeric().getData()[0];
                double powAtlst1 = RControl.getR().eval(".powerResult$PowAtlst1").asRNumeric().getData()[0];
                double rejectAll = RControl.getR().eval(".powerResult$RejectAll").asRNumeric().getData()[0];
                Double[] userDefined = new Double[this.listModel.getSize()];
                String[] functions = new String[this.listModel.getSize()];
                for (int i = 0; i < this.listModel.getSize(); ++i) {
                    functions[i] = this.listModel.get(i).toString();
                    userDefined[i] = RControl.getR().eval(".powerResult$userDefined" + i).asRNumeric().getData()[0];
                }
                this.parent.getGraphView().getNL().setPower(localPower, expRejections, powAtlst1, rejectAll, userDefined, functions);
            } else {
                settings = ", muL = " + this.pPanelMeans.getRList() + ", sigmaL = " + this.pPanelSigmas.getRList() + ", nL = " + this.pPanelN.getRList();
                String result = RControl.getR().eval("gMCP:::calcMultiPower(weights=" + weights + ", alpha=" + alpha + ", G=" + G + settings + "," + "sigma = " + this.dfp.getTable().getModel().getDataFrame().getRMatrix() + this.getMatrixForParametricTest() + userDefinedF + ", nSim = " + Configuration.getInstance().getGeneralConfig().getNumberOfSimulations() + ", type = \"" + Configuration.getInstance().getGeneralConfig().getTypeOfRandom() + "\"" + this.getVariables() + ")").asRChar().getData()[0];
                new TextFileViewer((JFrame)this.parent, "Power results", result, true);
            }
        }
        this.dispose();
    }

    private void load(SingleDataFramePanel dfp) {
        VariableNameDialog vnd = new VariableNameDialog(this.parent);
        try {
            double[] result = RControl.getR().eval("as.numeric(" + vnd.getName() + ")").asRNumeric().getData();
            int n = this.nodes.size();
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < n; ++j) {
                    dfp.getTable().getModel().setValueAt(new EdgeWeight(result[i * n + j]), i, j);
                }
            }
        }
        catch (Exception exc) {
            JOptionPane.showMessageDialog(this, "Could not load matrix \"" + vnd.getName() + "\":\n" + exc.getMessage(), "Could not load matrix", 0);
        }
    }

    public JPanel getCVPanel() {
        JPanel mPanel = new JPanel();
        GridBagConstraints c = PowerDialogParameterUncertainty.getDefaultGridBagConstraints();
        CellConstraints cc = new CellConstraints();
        int row = 2;
        String cols = "5dlu, fill:pref:grow, 5dlu, fill:pref:grow, 5dlu";
        String rows = "5dlu, pref, 5dlu, fill:pref:grow, 5dlu, pref, 5dlu";
        if (this.parent.getPView().jrbRCorrelation.isSelected()) {
            rows = rows + ", pref, 5dlu, fill:pref:grow, 5dlu, pref, 5dlu";
        }
        mPanel.setLayout((LayoutManager)new FormLayout(cols, rows));
        cc = new CellConstraints();
        mPanel.add((Component)new JLabel("Covariance matrix of test statistics"), cc.xyw(2, row, 3));
        mPanel.add((Component)new JScrollPane(this.dfp), cc.xyw(2, row += 2, 3));
        mPanel.add((Component)this.loadCV, cc.xy(2, row += 2));
        this.loadCV.addActionListener(this);
        mPanel.add((Component)this.createCV, cc.xy(4, row));
        this.createCV.addActionListener(this);
        row += 2;
        if (this.parent.getPView().jrbRCorrelation.isSelected()) {
            mPanel.add((Component)this.secondCV, cc.xyw(2, row, 3));
            this.secondCV.addActionListener(this);
            mPanel.add((Component)new JScrollPane(this.dfp2), cc.xyw(2, row += 2, 3));
            mPanel.add((Component)this.loadCV2, cc.xy(2, row += 2));
            this.loadCV2.addActionListener(this);
            this.loadCV2.setEnabled(false);
            mPanel.add((Component)this.createCV2, cc.xy(4, row));
            this.createCV2.addActionListener(this);
            this.createCV2.setEnabled(false);
        }
        return mPanel;
    }

    private String getMatrixForParametricTest() {
        if (this.parent.getPView().jrbRCorrelation.isSelected()) {
            SingleDataFramePanel df = this.secondCV.isSelected() ? this.dfp2 : this.dfp;
            return ", cr=" + df.getTable().getModel().getDataFrame().getRMatrix() + ", test=\"" + Configuration.getInstance().getGeneralConfig().getParametricTest() + "\"";
        }
        return "";
    }

    public JPanel getMultiSettingPanel() {
        JPanel mPanel = new JPanel();
        JTabbedPane parameters = new JTabbedPane();
        this.pPanelMeans = new PowerParameterPanel("mean", 0.0, this.nodes, this.parent);
        this.pPanelSigmas = new PowerParameterPanel("sd", 1.0, this.nodes, this.parent);
        this.pPanelN = new PowerParameterPanel("sample size", 10.0, this.nodes, this.parent);
        parameters.addTab("Mean \u00b5", this.pPanelMeans);
        parameters.addTab("Standard deviation \u03c3", this.pPanelSigmas);
        parameters.addTab("Sample size n", this.pPanelN);
        String cols = "5dlu, fill:pref:grow, 5dlu, fill:pref:grow, 5dlu";
        String rows = "5dlu, fill:pref:grow, 5dlu, pref, 5dlu";
        mPanel.setLayout((LayoutManager)new FormLayout(cols, rows));
        CellConstraints cc = new CellConstraints();
        int row = 2;
        mPanel.add((Component)parameters, cc.xy(2, row));
        return mPanel;
    }

    public JPanel getSettingPanel() {
        this.panelOne = this.getSingleSettingPanel();
        this.panelMany = this.getMultiSettingPanel();
        JPanel mPanel = new JPanel();
        String cols = "5dlu, pref, 5dlu, fill:pref:grow, 5dlu";
        String rows = "5dlu, pref, 5dlu, fill:pref:grow, 5dlu";
        mPanel.setLayout((LayoutManager)new FormLayout(cols, rows));
        CellConstraints cc = new CellConstraints();
        int row = 2;
        mPanel.add((Component)new JLabel("Number of Settings: "), cc.xy(2, row));
        mPanel.add((Component)this.numberOfSettings, cc.xy(4, row));
        this.numberOfSettings.addActionListener(this);
        row += 2;
        this.panel2.setLayout(new GridBagLayout());
        if (Boolean.parseBoolean(Configuration.getInstance().getClassProperty(this.getClass(), "singleSetting", "true"))) {
            this.panel2.add((Component)this.panelOne, PowerDialogParameterUncertainty.getDefaultGridBagConstraints());
            this.numberOfSettings.setSelectedIndex(0);
        } else {
            this.panel2.add((Component)this.panelMany, PowerDialogParameterUncertainty.getDefaultGridBagConstraints());
            this.numberOfSettings.setSelectedIndex(1);
        }
        mPanel.add((Component)this.panel2, cc.xyw(2, row, 3));
        return mPanel;
    }

    public JPanel getSingleSettingPanel() {
        JPanel mPanel = new JPanel();
        GridBagConstraints c = PowerDialogParameterUncertainty.getDefaultGridBagConstraints();
        String cols = "5dlu, pref, 5dlu, fill:pref:grow, 5dlu";
        String cols2 = "5dlu, pref, 5dlu, fill:pref:grow, 5dlu, fill:pref:grow, 5dlu, fill:pref:grow, 5dlu";
        String rows = "5dlu, pref, 5dlu";
        for (Node n : this.nodes) {
            rows = rows + ", pref, 5dlu";
        }
        FormLayout layout = new FormLayout(cols, rows);
        this.singleNCP.setLayout((LayoutManager)layout);
        layout = new FormLayout(cols2, rows);
        this.singleMuSigmaN.setLayout((LayoutManager)layout);
        CellConstraints cc = new CellConstraints();
        int row = 2;
        this.singleMuSigmaN.add((Component)new JLabel("\u00b5"), cc.xy(4, row));
        this.singleMuSigmaN.add((Component)new JLabel("\u03c3"), cc.xy(6, row));
        this.singleMuSigmaN.add((Component)new JLabel("n"), cc.xy(8, row));
        this.jtl = new Vector<JTextField>();
        this.jtlMu = new Vector<JTextField>();
        this.jtlSigma = new Vector<JTextField>();
        this.jtlN = new Vector<JTextField>();
        for (Node n : this.nodes) {
            JTextField jt = new JTextField("0");
            this.singleNCP.add((Component)new JLabel("Noncentrality parameter for '" + n.getName() + "':"), cc.xy(2, row));
            this.singleNCP.add((Component)jt, cc.xy(4, row));
            this.jtl.add(jt);
            this.singleMuSigmaN.add((Component)new JLabel("Parameters for '" + n.getName() + "':"), cc.xy(2, row += 2));
            jt = new JTextField("0");
            this.singleMuSigmaN.add((Component)jt, cc.xy(4, row));
            this.jtlMu.add(jt);
            jt = new JTextField("1");
            this.singleMuSigmaN.add((Component)jt, cc.xy(6, row));
            this.jtlSigma.add(jt);
            jt = new JTextField("10");
            this.singleMuSigmaN.add((Component)jt, cc.xy(8, row));
            this.jtlN.add(jt);
        }
        cols = "5dlu, fill:pref:grow, 5dlu, fill:pref:grow, 5dlu";
        rows = "5dlu, pref, 5dlu, fill:pref:grow, 5dlu, pref, 5dlu";
        mPanel.setLayout((LayoutManager)new FormLayout(cols, rows));
        cc = new CellConstraints();
        row = 2;
        mPanel.add((Component)new JLabel("Noncentrality parameter of multivariate normal distribution"), cc.xy(2, row));
        row += 2;
        this.panel.setLayout(new GridBagLayout());
        if (Boolean.parseBoolean(Configuration.getInstance().getClassProperty(this.getClass(), "ncp", "true"))) {
            this.panel.add((Component)this.singleNCP, c);
        } else {
            this.panel.add((Component)this.singleMuSigmaN, c);
        }
        mPanel.add((Component)new JScrollPane(this.panel), cc.xy(2, row));
        mPanel.add((Component)this.switchNCP, cc.xy(2, row += 2));
        this.switchNCP.addActionListener(this);
        return mPanel;
    }

    private String getUserDefined() {
        if (this.listModel.getSize() == 0) {
            return "";
        }
        String s = ", f=list(";
        for (int i = 0; i < this.listModel.getSize(); ++i) {
            s = s + "userDefined" + i + "=function(x) {" + this.listModel.get(i) + "}";
            if (i == this.listModel.getSize() - 1) continue;
            s = s + ",";
        }
        return s + ")";
    }

    public JPanel getUserDefinedFunctions() {
        JPanel mPanel = new JPanel();
        JButton b = new JButton("(");
        b.setActionCommand("(");
        this.buttons.add(b);
        b = new JButton(")");
        b.setActionCommand(")");
        this.buttons.add(b);
        b = new JButton("AND");
        b.setActionCommand("&&");
        this.buttons.add(b);
        b = new JButton("OR");
        b.setActionCommand("||");
        this.buttons.add(b);
        b = new JButton("NOT");
        b.setActionCommand("!");
        this.buttons.add(b);
        for (int i = 0; i < this.nodes.size(); ++i) {
            b = new JButton(this.nodes.get(i).getName());
            b.setActionCommand("x[" + (i + 1) + "]");
            this.buttons2.add(b);
        }
        JPanel hypPanel = new JPanel();
        for (JButton button : this.buttons2) {
            button.addActionListener(this);
            hypPanel.add(button);
        }
        JPanel opPanel = new JPanel();
        for (JButton button : this.buttons) {
            button.addActionListener(this);
            opPanel.add(button);
        }
        this.jta.setMargin(new Insets(4, 4, 4, 4));
        this.jta.setText("In the text field above you can enter an user defined power function.\nUse the R syntax and \"x[i]\" to specify the proposition that hypothesis i\ncould be rejected. Alternatively use the buttons below.\nExample:  (x[1] && x[2]) || x[4]\nThis calculates the probability that the first and second\nor (not exclusive) the fourth null hypothesis can be rejected.\nNote that you can use all R commands, for example also\nany(x) to see whether any hypotheses was rejected or\nall(x[1:4]) to see whether all of the first four hypotheses were rejected.\nHit return to add another power function.");
        String cols = "5dlu, fill:pref:grow, 5dlu, fill:pref:grow, 5dlu";
        String rows = "5dlu, pref, 5dlu, fill:pref:grow, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu";
        mPanel.setLayout((LayoutManager)new FormLayout(cols, rows));
        CellConstraints cc = new CellConstraints();
        int row = 2;
        this.jtUserDefined.addActionListener(this);
        mPanel.add((Component)this.jtUserDefined, cc.xy(2, row));
        this.addAnother.addActionListener(this);
        mPanel.add((Component)this.addAnother, cc.xy(4, row));
        this.listModel = new DefaultListModel();
        this.listUserDefined = new JList(this.listModel);
        mPanel.add((Component)new JScrollPane(this.jta), cc.xywh(2, row += 2, 1, 3));
        mPanel.add((Component)new JScrollPane(this.listUserDefined), cc.xy(4, row));
        this.clearList.addActionListener(this);
        mPanel.add((Component)this.clearList, cc.xy(4, row += 2));
        mPanel.add((Component)new JScrollPane(hypPanel), cc.xyw(2, row += 2, 3));
        mPanel.add((Component)new JScrollPane(opPanel), cc.xyw(2, row += 2, 3));
        row += 2;
        return mPanel;
    }

    public JPanel getVariablePanel(Set<String> v) {
        JPanel vPanel = new JPanel();
        this.variables = v.toArray();
        String cols = "5dlu, pref, 5dlu, fill:pref:grow, 5dlu";
        String rows = "5dlu, pref, 5dlu";
        for (Object s : this.variables) {
            rows = rows + ", pref, 5dlu";
        }
        FormLayout layout = new FormLayout(cols, rows);
        vPanel.setLayout((LayoutManager)layout);
        CellConstraints cc = new CellConstraints();
        int row = 2;
        this.jtlVar = new Vector<JTextField>();
        for (Object s : this.variables) {
            JTextField jt = new JTextField("0");
            if (s.equals("\u03b5")) {
                jt.setText("" + Configuration.getInstance().getGeneralConfig().getEpsilon());
            } else {
                jt.setText("" + Configuration.getInstance().getGeneralConfig().getVariable(s.toString()));
            }
            vPanel.add((Component)new JLabel("Value for '" + s + "':"), cc.xy(2, row));
            vPanel.add((Component)jt, cc.xy(4, row));
            this.jtlVar.add(jt);
            row += 2;
        }
        return vPanel;
    }

    public String getVariables() {
        if (this.jtlVar.size() > 0) {
            String s = ", variables=list(";
            for (int i = 0; i < this.variables.length; ++i) {
                s = s + EdgeWeight.UTF2LaTeX(this.variables[i].toString().charAt(0)) + " = " + this.jtlVar.get(i).getText();
                if (i == this.variables.length - 1) continue;
                s = s + ", ";
            }
            return s + ")";
        }
        return "";
    }
}

