/*
 * Decompiled with CFR 0.152.
 */
package org.af.gMCP.gui.power;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.text.BadLocationException;
import org.af.gMCP.gui.graph.Node;
import org.af.gMCP.gui.power.KoutofNDialog;
import org.af.gMCP.gui.power.PDialog;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserDefinedPanel
extends JPanel
implements ActionListener {
    private static final String K_OUT_OF_N = "k out of n";
    List<JButton> buttons = new Vector<JButton>();
    List<JButton> buttons2 = new Vector<JButton>();
    JTextField jtUserDefined = new JTextField();
    JButton addAnother = new JButton("Add another power function");
    JButton clearList = new JButton("Clear");
    DefaultListModel<String> listModel;
    JList listUserDefined;
    JTextArea jta = new JTextArea();
    JButton loadUDPF = new JButton("Load");
    JButton saveUDPF = new JButton("Save");
    List<Node> nodes;
    JDialog parent;
    boolean justOne;

    public UserDefinedPanel(PDialog parent, Vector<Node> nodes) {
        this(parent, nodes, false);
    }

    public UserDefinedPanel(JDialog parent, List<Node> nodes, boolean justOne) {
        this.nodes = nodes;
        this.parent = parent;
        this.justOne = justOne;
        JButton b = new JButton("(");
        b.setActionCommand("(");
        this.buttons.add(b);
        b = new JButton(")");
        b.setActionCommand(")");
        this.buttons.add(b);
        b = new JButton("AND");
        b.setActionCommand("&&");
        this.buttons.add(b);
        b = new JButton("OR");
        b.setActionCommand("||");
        this.buttons.add(b);
        b = new JButton("NOT");
        b.setActionCommand("!");
        this.buttons.add(b);
        b = new JButton("At least k out of n");
        b.setActionCommand(K_OUT_OF_N);
        this.buttons.add(b);
        for (int i = 0; i < nodes.size(); ++i) {
            b = new JButton(nodes.get(i).getName());
            b.setActionCommand("x[" + (i + 1) + "]");
            this.buttons2.add(b);
        }
        JPanel hypPanel = new JPanel();
        for (JButton button : this.buttons2) {
            button.addActionListener(this);
            hypPanel.add(button);
        }
        JPanel opPanel = new JPanel();
        for (JButton button : this.buttons) {
            button.addActionListener(this);
            opPanel.add(button);
        }
        this.jta.setMargin(new Insets(4, 4, 4, 4));
        this.jta.setText("In the text field above you can enter an user defined power function.\nUse the R syntax and \"x[i]\" to specify the proposition that hypothesis i\ncould be rejected. Alternatively use the buttons below.\nExample:  (x[1] && x[2]) || x[4]\nThis calculates the probability that the first and second\nor (not exclusive) the fourth null hypothesis can be rejected.\n(Negation (!) takes precedence over 'and' (&&), which takes precedence over 'or' (||).\nIn doubt use brackets.)\nNote that you can use all R commands, for example\nany(x) to see whether any hypotheses was rejected or\nall(x[1:4]) to see whether all of the first four hypotheses were rejected." + (justOne ? "" : "\nHit return to add another power function."));
        String cols = "5dlu, fill:pref:grow, 5dlu, fill:pref:grow, 5dlu";
        String rows = "5dlu, pref, 5dlu, fill:pref:grow, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu";
        this.setLayout((LayoutManager)new FormLayout(cols, rows));
        CellConstraints cc = new CellConstraints();
        int row = 2;
        if (justOne) {
            this.add((Component)this.jtUserDefined, cc.xyw(2, row, 3));
        } else {
            this.jtUserDefined.addActionListener(this);
            this.add((Component)this.jtUserDefined, cc.xy(2, row));
            this.addAnother.addActionListener(this);
            this.add((Component)this.addAnother, cc.xy(4, row));
        }
        row += 2;
        this.listModel = new DefaultListModel();
        this.listUserDefined = new JList<String>(this.listModel);
        if (justOne) {
            this.add((Component)new JScrollPane(this.jta), cc.xywh(2, row, 3, 3));
        } else {
            this.add((Component)new JScrollPane(this.jta), cc.xywh(2, row, 1, 3));
            this.add((Component)new JScrollPane(this.listUserDefined), cc.xy(4, row));
        }
        row += 2;
        this.clearList.addActionListener(this);
        if (!justOne) {
            this.add((Component)this.clearList, cc.xy(4, row));
        }
        this.add((Component)new JScrollPane(hypPanel), cc.xyw(2, row += 2, 3));
        this.add((Component)new JScrollPane(opPanel), cc.xyw(2, row += 2, 3));
    }

    public String getUserDefined() {
        if (this.justOne) {
            return this.jtUserDefined.getText();
        }
        String s = "list(";
        for (int i = 0; i < this.listModel.getSize(); ++i) {
            s = s + "'" + this.listModel.get(i) + "'=function(x) {" + this.listModel.get(i) + "}";
            if (i == this.listModel.getSize() - 1) continue;
            s = s + ",";
        }
        return s + ")";
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e != null && (this.buttons.contains(e.getSource()) || this.buttons2.contains(e.getSource()))) {
            String command = ((JButton)e.getSource()).getActionCommand();
            if (command.equals(K_OUT_OF_N)) {
                KoutofNDialog koon = new KoutofNDialog(this.parent, this.nodes);
                command = koon.getCommand();
            }
            try {
                this.jtUserDefined.getDocument().insertString(this.jtUserDefined.getCaretPosition(), command, null);
            }
            catch (BadLocationException e1) {
                this.jtUserDefined.setText(this.jtUserDefined.getText() + " " + command);
            }
            return;
        }
        if (e != null && e.getSource() == this.clearList) {
            this.listModel.removeAllElements();
            return;
        }
        if (this.jtUserDefined.getText().length() > 0) {
            this.listModel.addElement(this.jtUserDefined.getText());
            this.jtUserDefined.setText("");
        }
    }

    public Element getConfigNode(Document document) {
        Element e = document.createElement("powerfunctions");
        for (int i = 0; i < this.listModel.getSize(); ++i) {
            Element ef = document.createElement("userdefined");
            ef.setAttribute("expression", "" + this.listModel.get(i));
            e.appendChild(ef);
        }
        return e;
    }

    public void loadConfig(Element e) {
        NodeList nlist = e.getChildNodes();
        int i = nlist.getLength() - 1;
        while (this.listModel.getSize() < nlist.getLength()) {
            this.listModel.insertElementAt(((Element)nlist.item(i)).getAttribute("expression"), 0);
            --i;
        }
    }
}

