% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/BasicInterface.R, R/command-stack.R, R/guiToolkit.R, R/icons.R, R/ws-model.R
\docType{class}
\name{Observer-class}
\alias{BasicToolkitInterface}
\alias{BasicToolkitInterface-class}
\alias{Command}
\alias{Command-class}
\alias{CommandList}
\alias{CommandList-class}
\alias{CommandStack}
\alias{CommandStack-class}
\alias{GWidgets2Icons}
\alias{GWidgets2Icons-class}
\alias{Handler}
\alias{Handler-class}
\alias{Observable}
\alias{Observable-class}
\alias{Observer}
\alias{Observer-class}
\alias{WSWatcherModel}
\alias{WSWatcherModel-class}
\alias{guiWidgetsToolkit-class}
\title{Reference class to create an observer of an observable object}
\arguments{
\item{...}{passed to constructor}
}
\description{
An observer can be observed

Handler is a special observer with obj and actino passed as first argument

Observable class sets up objects that can be observed. Inherited by template

This interface is inherited by the base GComponent classes in the
toolkit implementations. The methods defined here are referenced
by the S3 methods. For exampe, \code{svalue} dispatches to
\code{get_value} or \code{get_index}.

Class for commands. Has methods do, redo, undo

Class for multple commands

A list with ptr. delegates call of do or undo to appropriate command

A class to record the toolkit a gui object uses

Class for icons

A reference class to create a model that monitors the global
workspace. The class has method \code{update_state} and the
"getting" methods \code{get_by_class}, \code{get_by_function}
(filter), \code{get_changes}. Use with a \code{gtimer} instance to
keep up to date with changes to the workspace.
}
\details{
We combine both widget and container methods here. It isn't
perfect, but they do share quite a bit. Perhaps, we could make the
container class subclass the basic interface.
}
\section{Methods}{

\describe{
\item{\code{update(...)}}{Call self.}

\item{\code{update(...)}}{Call self.}

\item{\code{add_observer(o, signal = "DEFAULT")}}{Add an observer. Return id for block/remove/...}

\item{\code{block_observer(id)}}{Block observers. If o missing, block all}

\item{\code{block_observers()}}{Block all observers}

\item{\code{notify_observers(..., signal = "DEFAULT")}}{Call each non-blocked observer}

\item{\code{remove_observer(id)}}{Remove observer}

\item{\code{unblock_observer(id)}}{Unblock observer. If id missing, unblock global block}

\item{\code{unblock_observers()}}{Remove block of all observers. Keeps count, so may need to call again}

\item{\code{add_handler(signal, handler, action, ...)}}{Add a handler to be called for the event indicated by signal}

\item{\code{get_enabled()}}{is widget sensistive to user input}

\item{\code{get_index(drop = NULL, ...)}}{svalue; index=TRUE}

\item{\code{get_value(drop = NULL, ...)}}{Get main value of widget. From `svalue` when index = FALSE or NULL}

\item{\code{set_enabled(value, ...)}}{specify with logical if widget is sensistive to user input}

\item{\code{set_value(value, ..., drop = NULL)}}{for `svalue<-` when index = FALSE or NULL}

\item{\code{any_changes(...)}}{Report  if any changes}

\item{\code{filter_names(f)}}{Filter the names by f}

\item{\code{get_by_class(classes = character(0))}}{Return objects matching any of classes}

\item{\code{get_by_function(f)}}{Filter objects by function f}

\item{\code{get_changes()}}{Return list of changes}

\item{\code{initialize(...)}}{Initialze state of cached objects}

\item{\code{pop_changes()}}{pop changes, reset}

\item{\code{update_state(...)}}{update cache of names/digests, then notify observers if there are changes}
}}

