/*
 * Decompiled with CFR 0.152.
 */
package gWidgetsrJava;

import java.awt.Color;
import java.awt.Component;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class ColoredTable
extends JTable {
    private Color oddColor;
    private Color evenColor;

    public ColoredTable(TableModel tableModel, TableColumnModel tableColumnModel) {
        super(tableModel, tableColumnModel);
        this.updateColors();
    }

    public ColoredTable(TableModel tableModel) {
        super(tableModel);
        this.updateColors();
    }

    public ColoredTable() {
        this.updateColors();
    }

    public Color getBackgroundColor(int n) {
        return n % 2 == 1 ? this.oddColor : this.evenColor;
    }

    private void updateColors() {
        this.evenColor = UIManager.getColor("Table.background");
        this.oddColor = this.evenColor != null ? new Color(Math.max((int)((double)this.evenColor.getRed() * 0.9), 0), Math.max((int)((double)this.evenColor.getGreen() * 0.9), 0), Math.max((int)((double)this.evenColor.getBlue() * 0.9), 0)) : null;
    }

    public void updateUI() {
        super.updateUI();
        this.updateColors();
    }

    public Component prepareRenderer(TableCellRenderer tableCellRenderer, int n, int n2) {
        boolean bl;
        Component component = super.prepareRenderer(tableCellRenderer, n, n2);
        boolean bl2 = this.isCellSelected(n, n2);
        boolean bl3 = this.selectionModel.getAnchorSelectionIndex() == n;
        boolean bl4 = this.columnModel.getSelectionModel().getAnchorSelectionIndex() == n2;
        boolean bl5 = bl = bl3 && bl4 && this.hasFocus();
        if (!bl2 && !bl) {
            component.setBackground(this.getBackgroundColor(n));
        }
        return component;
    }
}

