\name{simul.fandtasia}
\alias{simul.fandtasia}
\concept{Simulation}
\concept{Glyph field mapping}

\title{Simulation of Curved Fibre Bundles for von Mises-Fisher Fibre Orientation Mapping}
\description{
The synthesized field of diffusion profiles generated by \code{simul.fandtasia} are used to reconstruct ODF profiles using the GQI method.
ODF profiles and fibre directions are estimated by relying on von Mises-Fisher (vMF) distributions for directional mapping. 
}

\usage{
simul.fandtasia(gdi="gqi", gridsz=32, b=4000, depth=3, sigma=0.01,
 threshold=0.5, showglyph=FALSE, savedir=tempdir(), snapshot=FALSE,
 pngfig="fandtasia")
}

\arguments{
\item{gdi}{ method of ODF reconstruction to use \code{c("gqi", "gqi2")} (default: \code{"gqi"}). }
\item{gridsz}{ dimension of squared grid to use in simulation (default 32)}
\item{b}{ strength of the magnetic diffusion gradient (default b-value=4000). }
\item{depth}{ sampling densities on the hemisphere used in simulation (default N=321; depth=3). }
\item{sigma}{ Rician noise level used in simulation; (default \code{0.01}). }
\item{threshold}{ thresholding generalized fractional anisotropy (GFA) value at each voxel (default: 0.5). }
\item{showglyph}{ logical variable controlling visualization of voxel glyphs (default: \code{FALSE}). }
\item{savedir}{ directory for saving/loading processed results (default: \code{tempdir()}. }
\item{snapshot}{ logical variable controlling line-maps snapshots (default: \code{FALSE}). }
\item{pngfig}{ base-name of the PNG file when \code{snapshot} is \code{TRUE} (default \code{"fandtasia"}). }
}

\details{
Noisy profiles may be simulated by adding Rician noise to the simulated diffusion profile, with a user defined standard deviation level specified as \eqn{\sigma} (SNR=1/\eqn{\sigma}). 
The procedure is adapted from Barmpoutis' code to generate synthetic tensor diffusion-weighted MRI fields.
The procedure is very time intensive for grids of size \code{32x32}.
}

\value{
\code{simul.fandtasia} returns a field of 32x32 diffusion profiles in NIfTI format.
}

\references{
Ferreira da Silva, A. R. Computational Representation of White Matter Fiber Orientations, \emph{International Journal of Biomedical Imaging}, Vol. 2013, Article ID 232143, Hindawi Publishing Corporation \url{http://dx.doi.org/10.1155/2013/232143}.

Ferreira da Silva, A. R. Facing the Challenge of Estimating Human Brain White Matter Pathways. In \emph{Proc. of the 4th International Joint Conference on Computational Intelligence} (Oct. 2012), K. Madani, J. Kacprzyk, and J. Filipe, Eds., SciTePress, pp. 709-714.

Hornik, K., and Gruen, B. \pkg{movMF}: Mixtures of von Mises-Fisher Distributions, 2012. R package version 0.1-0.

Barmpoutis, A. Tutorial on Diffusion Tensor MRI using Matlab. Electronic Edition, University of Florida, 2010,\cr
\url{http://www.mathworks.com/matlabcentral/fileexchange/file_infos/26997-fandtasia-toolbox}.\cr
} 

\author{ Adelino Ferreira da Silva, Universidade Nova de Lisboa,
  Faculdade de Ciencias e Tecnologia, Portugal, \email{afs at fct.unl.pt}
}

\seealso{
  \code{\link{simul.fandtasiaSignal}},
  \code{\link{simulglyph.vmf}},
  \code{\link{simul.simplefield}}
}

\examples{
\dontrun{
    ## simulation with a new generated field of profiles,
    ## of size 16x16 (for speed), with added noise 
    simul.fandtasia(gridsz=16, sigma=0.01)
    simul.fandtasia(gdi="gqi2", gridsz=16, sigma=0.01)
    ## same as before, but showing crossing-fibre glyphs 
    simul.fandtasia(gridsz=16, sigma=0.01, showglyph=TRUE)
    simul.fandtasia(gdi="gqi2", gridsz=16, sigma=0.01, showglyph=TRUE)
    ## using a 32x32 data field as in the original reference
    ## Warning: time-consuming example
    simul.fandtasia()
}
}

\keyword{ utilities }

