% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/gelnet.R
\name{gelnet.logreg}
\alias{gelnet.logreg}
\title{GELnet for logistic regression}
\usage{
gelnet.logreg(X, y, l1, l2, d = rep(1, p), P = diag(p), m = rep(0, p),
  max.iter = 100, eps = 1e-05, w.init = rep(0, p), b.init = 0.5,
  silent = FALSE)
}
\arguments{
\item{X}{n-by-p matrix of n samples in p dimensions}

\item{y}{n-by-1 vector of binary response labels}

\item{l1}{coefficient for the L1-norm penalty}

\item{l2}{coefficient for the L2-norm penalty}

\item{d}{p-by-1 vector of feature weights}

\item{P}{p-by-p feature association penalty matrix}

\item{m}{p-by-1 vector of translation coefficients}

\item{max.iter}{maximum number of iterations}

\item{eps}{convergence precision}

\item{w.init}{initial parameter estimate for the weights}

\item{b.init}{initial parameter estimate for the bias term}

\item{silent}{set to TRUE to suppress run-time output to stdout (default: FALSE)}
}
\value{
A list with two elements:
\describe{
  \item{w}{p-by-1 vector of p model weights}
  \item{b}{scalar, bias term for the linear model}
}
}
\description{
Constructs a GELnet model for logistic regression using the Newton method.
}
\details{
The method operates by constructing iteratively re-weighted least squares approximations
of the log-likelihood loss function and then calling the linear regression routine
to solve those approximations. The least squares approximations are obtained via the Taylor series
expansion about the current parameter estimates.
}
\seealso{
\code{\link{gelnet.lin}}
}

