% Generated by roxygen2 (4.0.2): do not edit by hand
\name{plot.xtree.pls}
\alias{plot.xtree.pls}
\title{Plot function for the Pathmox Segmentation Trees: PLS-PM}
\usage{
\method{plot}{xtree.pls}(x, root.col = "grey", node.col = "orange",
  leaf.col = "green2", shadow.size = 0.003, node.shadow = "red",
  leaf.shadow = "darkgreen", cex = 0.7, seg.col = "blue3", lwd = 1,
  show.pval = TRUE, pval.col = "blue", main = NULL, cex.main = 1, ...)
}
\arguments{
\item{x}{An object of class \code{"xtree.pls"} returned by
\code{\link{pls.pathmox}}}

\item{root.col}{Fill color of root node.}

\item{node.col}{Fill color of child nodes.}

\item{leaf.col}{Fill color of leaf.}

\item{shadow.size}{Relative size of shadows.}

\item{node.shadow}{Color of shadow of child nodes.}

\item{leaf.shadow}{Color of shadow of leaf nodes.}

\item{cex}{A numerical value indicating the magnification to be used for
plotting text.}

\item{seg.col}{The color to be used for the labels of the segmentation
variables.}

\item{lwd}{The line width, a positive number, defaulting to 1}

\item{show.pval}{Logical value indicating whether the p-values should be
plotted.}

\item{pval.col}{The color to be used for the labels of the p-values.}

\item{main}{A main title for the plot.}

\item{cex.main}{The magnification to be used for the main title.}

\item{\dots}{Further arguments passed on to \code{\link{plot.xtree.pls}}.}
}
\description{
The function \code{plot.xtree.pls} allows to drow PATHMOX tree for PLS-PM
}
\examples{
\dontrun{
 ## example of PLS-PM in alumni satisfaction

 data(fibtele)

 # select manifest variables
 data.fib <-fibtele[,12:35]

 # define inner model matrix
 Image 			= rep(0,5)
	 Qual.spec	= rep(0,5)
	 Qual.gen		= rep(0,5)
	 Value			= c(1,1,1,0,0)
	 Satis			= c(1,1,1,1,0)
 inner.fib <- rbind(Image,Qual.spec, Qual.gen, Value, Satis)
 colnames(inner.fib) <- rownames(inner.fib)

 # blocks of indicators (outer model)
 outer.fib <- list(1:8,9:11,12:16,17:20,21:24)
 modes.fib  = rep("A", 5)

 # apply plspm
 pls.fib <- plspm(data.fib, inner.fib, outer.fib, modes.fib)


 # re-ordering those segmentation variables with ordinal scale
  seg.fib= fibtele[,2:11]

	 seg.fib$Age = factor(seg.fib$Age, ordered=T)
	 seg.fib$Salary = factor(seg.fib$Salary,
		levels=c("<18k","25k","35k","45k",">45k"), ordered=T)
	 seg.fib$Accgrade = factor(seg.fib$Accgrade,
		levels=c("accnote<7","7-8accnote","accnote>8"), ordered=T)
	 seg.fib$Grade = factor(seg.fib$Grade,
		levels=c("<6.5note","6.5-7note","7-7.5note",">7.5note"), ordered=T)

 # Pathmox Analysis
 fib.pathmox=pls.pathmox(pls.fib,seg.fib,signif=0.05,
					deep=2,size=0.2,n.node=20)

 # plot pathmox tree
 plot(pls.fib)
 }
}

