% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/28_fun_pls.treenode.R
\name{treenode.pls}
\alias{treenode.pls}
\title{PLS-SEM results of a specific terminal node from the Pathmox Segmentation Trees}
\usage{
treenode.pls(xtree, node, boot.val = TRUE, br = 500)
}
\arguments{
\item{xtree}{An object of class \code{"xtree.pls"} returned by
\code{\link{pls.pathmox}}.}

\item{node}{is numeric value indicating the node that we want to aanalyze}

\item{boot.val}{is string, if equal to \code{TRUE}, calculates the bootstrap intervals.
By default is equal to \code{TRUE}.}

\item{br}{is the numebr of boostrap resempling. By default is equal to 500.}
}
\value{
An object of class \code{"treemodel.pls"}. Basically a list with the
following results:

\item{Reliability_indexes_and_unidimensionality}{Classical reliabilitiy indices for PLS-SEM}

\item{Internal_consistency_and_R2}{AVE and R2 for PLS-SEM}

\item{loadings}{Outer model loadings}

\item{weights}{Outer model weights}

\item{discriminant_validity}{Discriminant validity - Fornell & Larcker criterion}

\item{path_coef}{Coefficients of the inner model}

\item{total_effects}{Total effects of the inner model}
}
\description{
Calculates basic PLS-SEM results for a specific terminal node of PATHMOX
trees
}
\details{
The argument \code{xtree} is an object of class \code{"xtree.pls"} returned by 
\code{\link{pls.pathmox}}.
}
\examples{
\dontrun{
 ## example of PLS-PM in bank customer satisfaction
 
data(csibank)

# select manifest variables
data.bank <-csibank[,6:32]

# define inner model matrix
Image 			  = rep(0,6)
Expectation	  = c(1,0,0,0,0,0)
Quality		    = c(0,1,0,0,0,0)
Value			    = c(0,1,1,0,0,0)
Satis			    = c(1,1,1,1,0,0)
Loyalty       = c(1,0,0,0,1,0)
inner.bank = rbind(Image,Expectation, Quality, Value, Satis,Loyalty)
colnames(inner.bank) = rownames(inner.bank)

# blocks of indicators (outer model)
outer.bank  = list(1:6,7:10,11:17,18:21,22:24,25:27)
modes.bank = rep("A", 6)


# re-ordering those segmentation variables with ordinal scale 
seg.bank= csibank[,1:5]

seg.bank$Age = factor(seg.bank$Age, ordered=TRUE)
seg.bank$Education = factor(seg.bank$Education, ordered=TRUE)


# Pathmox Analysis
bank.pathmox=pls.pathmox(data.bank, inner.bank, outer.bank, modes.bank,SVAR=seg.bank,signif=0.05,
                         deep=2,size=0.2,n.node=20)

treenode=treenode.pls(bank.pathmox,node=2,br=100)
 
 }
}
\references{
Lamberti, G. (2021) \emph{Hybrid multigroup partial least squares structural equation modelling: 
an application to bank employee satisfaction and loyalty}. 
Quality and Quantity; doi: 10.1007/s11135-021-01096-9;

Lamberti, G. et al. (2017) \emph{The Pathmox approach for PLS path modeling: 
Discovering which constructs differentiate segments.}. 
Applied Stochastic Models in Business and Industry; doi: 10.1002/asmb.2270;

Lamberti, G. et al. (2016) \emph{The Pathmox approach for PLS path modeling segmentation}. 
Applied Stochastic Models in Business and Industry; doi: 10.1002/asmb.2168;

Lamberti, G. (2015) \emph{Modeling with Heterogeneity.} PhD Dissertation.
}
\seealso{
\code{\link{pls.pathmox}}
}
\author{
Giuseppe Lamberti
}
