% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/26_fun_pls.pathmox.R
\name{pls.pathmox}
\alias{pls.pathmox}
\title{PATHMOX-PLS: Extended Segmentation Trees in 
Partial Least Squares Structutal Equation Modeling (PLS-SEM)}
\usage{
pls.pathmox(
  x,
  inner,
  outer,
  mode,
  scheme = "path",
  scaling = NULL,
  scaled = TRUE,
  SVAR,
  signif = 0.05,
  deep,
  method = "lm",
  size,
  tree = TRUE,
  n.node = 30,
  ...
)
}
\arguments{
\item{x}{matrix or data frame containing the manifest variables.}

\item{inner}{A square (lower triangular) boolean matrix representing 
the inner model (i.e. the path relationships between latent variables).}

\item{outer}{list of vectors with column indices or column names
from \code{x} indicating the sets of manifest variables forming 
each block (i.e. which manifest variables correspond to each block).}

\item{mode}{character vector indicating the type of measurement for each
block. Possible values are: \code{"A", "B", "newA", "PLScore", "PLScow"}. 
The length of \code{mode} must be equal to the length of \code{outer}.}

\item{scheme}{string indicating the type of inner weighting
scheme. Possible values are \code{"centroid"}, \code{"factorial"}, or
\code{"path"}.}

\item{scaling}{optional argument for runing the non-metric approach; 
it is a list of string vectors indicating the type of 
measurement scale for each manifest variable specified in \code{outer}.
\code{scaling} must be specified when working with non-metric variables.
Possible values: \code{"num"} (linear transformation, 
suitable for numerical variables), \code{"raw"} (no transformation), 
\code{"nom"} (non-monotonic transformation, suitable for nominal variables), 
and \code{"ord"} (monotonic transformation, suitable for ordinal variables).}

\item{scaled}{whether manifest variables should be standardized. 
Only used when \code{scaling = NULL}. By the default (\code{TRUE}, data is 
scaled to standardized values (mean=0 and variance=1).}

\item{SVAR}{A data frame of factors contaning the segmentation variables.}

\item{signif}{A numeric value indicating the significance threshold of the
F-statistic. Must be a decimal number between 0 and 1.}

\item{deep}{An integer indicating the depth level of the tree. Must be an
integer greater than 1.}

\item{method}{A string indicating the criterion used to calculate the
the test can be equal to \code{"lm"} or \code{"lad"}.}

\item{size}{A numeric value indicating the minimum size of elements inside a
node.}

\item{tree}{A string indicating if the tree plot must be showed. By default is 
equal to \code{TRUE}}

\item{n.node}{It is the minimum number of individuals to consider a candidate 
partition (\code{30} by default).}

\item{\dots}{Further arguments passed on to \code{\link{pls.pathmox}}.}
}
\value{
An object of class \code{"xtree.pls"}. Basically a list with the
following results:

\item{MOX}{Data frame with the results of the segmentation tree}

\item{root}{List of elements contanined in the root node}

\item{terminal}{List of elements contanined in terminal nodes}

\item{nodes}{List of elements contanined in all nodes: terminal and intermediate}

\item{candidates}{List of data frames containing the candidate 
splits of each node partition}

\item{Fg.r}{Data frame containing the results of the F-global test 
for each node partition}

\item{Fc.r}{A list of data frames containing the results of the F-coefficients test 
for each node partition}

\item{model}{Informations about the internal paramenters}

\item{hybrid}{orginal dataset plus the hybird categorical factor defined according to the final segments idenfied by pathmox. Dataset is ordered by the hybird variable}
}
\description{
The function \code{pathmox.pls} calculates a binary segmentation tree in 
the context PLS-SEM  following the PATHMOX algorithm. It allows heterogeneity 
to be detected in PLS-SEM models when the segmentation variables (categorical variables), 
external to the model, are available and when the objective of the research is exploratory. 
Pathmox adapts the principles of binary segmentation processes to produce a tree with 
different models in each of the obtained nodes. Unlike classic decision trees, 
pathmox does not aim to predict predefined classes, but to detect different 
models present in the data. To this end, it identifies the splits 
(based on the segmentation variables) that maximally discriminate between models. 
Each binary split defines a pair of nodes, each of which will have an associated 
structural model, i.e., an associated set of path coefficients. A global comparison test 
on the identity of the two models is then run. To avoid overfitting, 
pathmox adopts a pre-pruning process (i.e., stopping rules) based on maximum depth,
 minimum size of nodes and non-significance of the F-statistic.
}
\details{
The argument \code{x} must be a data frame containing the manifest variables of the 
PLS-SEM model.

The argument \code{inner} is a matrix of zeros and ones that indicates
the structural relationships between latent variables. \code{inner} 
must be a lower triangular matrix; it contains a 1 when column \code{j}
affects row \code{i}, 0 otherwise.

The argument \code{SVAR} must be a data frame containing segmentation
variables as factors. The number of rows in
\code{SVAR} must be the same as the number of rows in the data used in
\code{x}. 
 
The argument \code{signif} represent the p-value level takes as reference  
to stop the tree partitions. Defaults value is 0.05.

The argument \code{deep} represent the depth level of the tree takes as reference  
to stop the tree partitions. 

The argument \code{method} is a string contaning the criterion used to calculate the   
tests; if \code{method="lm"} the classic least square approach is used to perform the tests; 
if \code{method="lad"} a LAD (least absolute deviation regression) aproximation of the test is used.

The argument \code{size} is defined as a decimal value (i.e. proportion
of elements inside a node). 

The argument \code{n.node} is the minimum number of individuals to consider a candidate 
partition. If the candidate split produces a partition where the number of individuals is less  
then \code{n.node}, the partition is not considered.
}
\examples{

\dontrun{
 ## example of PLS-PM in bank customer satisfaction
 
data(csibank)

# select manifest variables
data.bank <-csibank[,6:32]

# define inner model matrix
Image 			  = rep(0,6)
Expectation	  = c(1,0,0,0,0,0)
Quality		    = c(0,1,0,0,0,0)
Value			    = c(0,1,1,0,0,0)
Satis			    = c(1,1,1,1,0,0)
Loyalty       = c(1,0,0,0,1,0)
inner.bank = rbind(Image,Expectation, Quality, Value, Satis,Loyalty)
colnames(inner.bank) = rownames(inner.bank)

# blocks of indicators (outer model)
outer.bank  = list(1:6,7:10,11:17,18:21,22:24,25:27)
modes.bank = rep("A", 6)


# re-ordering those segmentation variables with ordinal scale 
seg.bank= csibank[,1:5]

seg.bank$Age = factor(seg.bank$Age, ordered=TRUE)
seg.bank$Education = factor(seg.bank$Education, ordered=TRUE)


# Pathmox Analysis
bank.pathmox=pls.pathmox(data.bank, inner.bank, outer.bank, modes.bank,SVAR=seg.bank,signif=0.05,
                         deep=2,size=0.2,n.node=20)
 
 }
 
 ## example of PLS-PM in bank customer satisfaction
 
data(csibank)

# select manifest variables
data.bank <-csibank[,6:32]

# define inner model matrix
Image 			  = rep(0,6)
Expectation	  = c(1,0,0,0,0,0)
Quality		    = c(0,1,0,0,0,0)
Value			    = c(0,1,1,0,0,0)
Satis			    = c(1,1,1,1,0,0)
Loyalty       = c(1,0,0,0,1,0)
inner.bank = rbind(Image,Expectation, Quality, Value, Satis,Loyalty)
colnames(inner.bank) = rownames(inner.bank)

# blocks of indicators (outer model)
outer.bank  = list(1:6,7:10,11:17,18:21,22:24,25:27)
modes.bank = rep("A", 6)


# re-ordering those segmentation variables with ordinal scale 
seg.bank= csibank[,1:5]

seg.bank$Age = factor(seg.bank$Age, ordered=TRUE)
seg.bank$Education = factor(seg.bank$Education, ordered=TRUE)


# Pathmox Analysis
bank.pathmox=pls.pathmox(data.bank, inner.bank, outer.bank, modes.bank,SVAR=seg.bank,signif=0.05,
                         deep=2,size=0.2,n.node=20)
                         
                         
}
\references{
Lamberti, G. (2021) \emph{Hybrid multigroup partial least squares structural equation modelling: 
an application to bank employee satisfaction and loyalty}. 
Quality and Quantity; doi: 10.1007/s11135-021-01096-9;

Lamberti, G. et al. (2017) \emph{The Pathmox approach for PLS path modeling: 
Discovering which constructs differentiate segments.}. 
Applied Stochastic Models in Business and Industry; doi: 10.1002/asmb.2270;

Lamberti, G. et al. (2016) \emph{The Pathmox approach for PLS path modeling segmentation}. 
Applied Stochastic Models in Business and Industry; doi: 10.1002/asmb.2168;

Lamberti, G. (2015) \emph{Modeling with Heterogeneity.} PhD Dissertation.
}
\author{
Giuseppe Lamberti
}
