% Generated by roxygen2 (4.0.1): do not edit by hand
\name{quantreg}
\alias{quantreg}
\title{Linear Programming - Quantile regression}
\usage{
quantreg(formula, tau = 0.5, lambda = 0)
}
\arguments{
\item{formula}{An object of class "formula" (e.g., y~X)}

\item{tau}{(optional) Quantile for quantile regression.  Default is 0.5 but can also be a vector (e.g., tau = c(0.25,0.5,0.75)).}

\item{lambda}{(optional) Regularization parameter.  Default is lambda=0 (i.e., no regularization).}
}
\description{
\code{quantreg} quantreg is used to fit quantile regression models.
}
\examples{
set.seed(12345)
n <- 20
p <- 20
X <- matrix(rnorm(n*p),n,p)
b0 <- double(p)
k <- 4
b0[sample(1:p,k,replace=FALSE)] <- 10*rnorm(k)
y <- X\%*\%b0 + 0.1*rnorm(n)

lambda <- 0
tau <- c(0.05,0.25,0.5,0.75,0.95)
sol <- quantreg(y~X,tau,lambda)
coef(sol)
}
\author{
Jocelyn T. Chi
}

