% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/removeGrid.R
\name{removeGrid}
\alias{removeGrid}
\alias{removeGridX}
\alias{removeGridY}
\title{Remove grid lines from ggplot2}
\usage{
removeGrid(x = TRUE, y = TRUE)

removeGridX()

removeGridY()
}
\arguments{
\item{x}{Whether to remove grid lines from the x axis.}

\item{y}{Whether to remove grid lines from the y axis.}
}
\value{
A ggplot2 layer that can be added to an existing ggplot2 object.
}
\description{
Remove grid lines from a ggplot2 plot, to have a cleaner and simpler
plot
}
\details{
Minor grid lines are always removed.

\code{removeGrid} removes the major grid lines from the x and/or y axis
(both by default).

\code{removeGridX} is a shortcut for \code{removeGrid(x = TRUE, y = FALSE)}

\code{removeGridY} is a shortcut for \code{removeGrid(x = FALSE, y = TRUE)}
}
\examples{
if (requireNamespace("ggplot2", quietly = TRUE)) {
  df <- data.frame(x = 1:50, y = 1:50)
  p <- ggplot2::ggplot(df, ggplot2::aes(x, y)) + ggplot2::geom_point()
  p + removeGrid()
  p + removeGrid(y = FALSE)
  p + removeGridX()
}
}

