% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allFunctions.R
\name{buildPathDF}
\alias{buildPathDF}
\title{Build data frame for path representation}
\usage{
buildPathDF(path, geneal, colName, colNameY = "")
}
\arguments{
\item{path}{path object representing the path between two vertices}

\item{geneal}{the full genealogy  (in data frame format)}

\item{colName}{the name of the column of the data frame that contains the quantitative variable of interest (in character string format)}

\item{colNameY}{the name of the second optional column of the data frame that contains the second optional quantitative variable of interest (in character string format). This optional quantitative variable will be plotted on the vertical axis.}
}
\description{
This function builds a dataframe of information about the path object that can later be used
for visualization. The dataframe includes "label" (name of each variety) of each node,
"x" (the date of the variety, the x-axis value for which the label and
incoming/outgoing edges are centered), "y" (the y-axis value, which is the index
of the path, incremented by unity), "xstart" (the x-axis position of the 
outgoing edge (leaving to connect to the node at the next largest y-value)),
"xend" (the x-axis position of the outgoing edge (connected to the node at the
next largest y-value)), "ystart" (the y-axis position of the outgoing edge (leaving
to connect to the node at the next largest y-value), "yend" (the y-axis position
of the outgoing edge (connected to the node at the next largest y-value))).
}

