% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggs_geweke.R
\name{ggs_geweke}
\alias{ggs_geweke}
\title{Dotplot of the Geweke diagnostic, the standard Z-score}
\usage{
ggs_geweke(D, family = NA, frac1 = 0.1, frac2 = 0.5,
  shadow_limit = TRUE, greek = FALSE)
}
\arguments{
\item{D}{data frame whith the simulations.}

\item{family}{Name of the family of parameters to plot, as given by a character vector or a regular expression. A family of parameters is considered to be any group of parameters with the same name but different numerical value between square brackets (as beta[1], beta[2], etc).}

\item{frac1}{Numeric, proportion of the first part of the chains selected. Defaults to 0.1.}

\item{frac2}{Numeric, proportion of the last part of the chains selected. Defaults to 0.5.}

\item{shadow_limit, }{logical. When TRUE (the default), a shadowed area between -2 and +2 is drawn.}

\item{greek}{Logical value indicating whether parameter labels have to be parsed to get Greek letters. Defaults to false.}
}
\value{
A \code{ggplot} object.
}
\description{
Dotplot of Geweke diagnostic.
}
\examples{
data(linear)
ggs_geweke(ggs(s))
}
\references{
Fernández-i-Marín, Xavier (2016) ggmcmc: Analysis of MCMC Samples and Bayesian Inference. Journal of Statistical Software, 70(9), 1-20. doi:10.18637/jss.v070.i09

Geweke, J. Evaluating the accuracy of sampling-based approaches to calculating posterior moments. In _Bayesian Statistics 4_ (ed JM Bernardo, JO Berger, AP Dawid and AFM Smith). Clarendon Press, Oxford, UK.
}

