\name{stat_bin}
\alias{stat_bin}
\alias{StatBin}
\title{stat\_bin}
\description{Bin data}
\details{
Missing values are currently silently dropped.

This page describes stat\_bin, see \code{\link{layer}} and \code{\link{qplot}} for how to create a complete plot from individual components.
}
\section{Aesthetics}{
The following aesthetics can be used with stat\_bin.  Aesthetics are mapped to variables in the data with the aes function: \code{stat\_bin(aes(x = var))}
\itemize{
  \item \code{x}: x position (\strong{required}) 
  \item \code{y}: y position 
}
}
\usage{stat_bin(mapping = NULL, data = NULL, geom = "bar", position = "stack", 
    width = 0.9, drop = FALSE, right = TRUE, ...)}
\arguments{
 \item{mapping}{mapping between variables and aesthetics generated by aes}
 \item{data}{dataset used in this layer, if not specified uses plot dataset}
 \item{geom}{geometric used by this layer}
 \item{position}{position adjustment used by this layer}
 \item{width}{Width of bars when used with categorical data}
 \item{drop}{If TRUE, remove all bins with zero counts}
 \item{right}{Should intervals be closed on the right (a, b], or not [a, b)}
 \item{...}{other arguments}
}
\seealso{\itemize{
  \item \url{http://had.co.nz/ggplot2/stat_bin.html}
}}
\value{A \code{\link{layer}}}
\examples{\dontrun{
simple <- data.frame(x = rep(1:10, each = 2))
base <- ggplot(simple, aes(x))
# By default, right = TRUE, and intervals are of the form (a, b]
base + stat_bin(binwidth = 1, drop = FALSE, right = TRUE, col = "black")
# If right = FALSE intervals are of the form [a, b)
base + stat_bin(binwidth = 1, drop = FALSE, right = FALSE, col = "black")

m <- ggplot(movies, aes(x=rating))
m + stat_bin()
m + stat_bin(binwidth=0.1)
m + stat_bin(breaks=seq(4,6, by=0.1))
# See geom_histogram for more histogram examples

# To create a unit area histogram, use aes(y = ..density..)
(linehist <- m + stat_bin(aes(y = ..density..), binwidth=0.1,
  geom="line", position="identity"))
linehist + stat_density(colour="blue", fill=NA)

# Also works with categorical variables
ggplot(movies, aes(x=mpaa)) + stat_bin()
qplot(mpaa, data=movies, stat="bin")

}}
\author{Hadley Wickham, \url{http://had.co.nz/}}
\keyword{hplot}
