% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale-date.r
\name{scale_date}
\alias{scale_x_date}
\alias{scale_y_date}
\alias{scale_x_datetime}
\alias{scale_y_datetime}
\alias{scale_x_time}
\alias{scale_y_time}
\title{Position scales for date/time data}
\usage{
scale_x_date(name = waiver(), breaks = waiver(), date_breaks = waiver(),
  labels = waiver(), date_labels = waiver(), minor_breaks = waiver(),
  date_minor_breaks = waiver(), limits = NULL, expand = waiver(),
  position = "bottom")

scale_y_date(name = waiver(), breaks = waiver(), date_breaks = waiver(),
  labels = waiver(), date_labels = waiver(), minor_breaks = waiver(),
  date_minor_breaks = waiver(), limits = NULL, expand = waiver(),
  position = "left")

scale_x_datetime(name = waiver(), breaks = waiver(),
  date_breaks = waiver(), labels = waiver(), date_labels = waiver(),
  minor_breaks = waiver(), date_minor_breaks = waiver(), timezone = NULL,
  limits = NULL, expand = waiver(), position = "bottom")

scale_y_datetime(name = waiver(), breaks = waiver(),
  date_breaks = waiver(), labels = waiver(), date_labels = waiver(),
  minor_breaks = waiver(), date_minor_breaks = waiver(), timezone = NULL,
  limits = NULL, expand = waiver(), position = "left")

scale_x_time(name = waiver(), breaks = waiver(), minor_breaks = waiver(),
  labels = waiver(), limits = NULL, expand = waiver(), oob = censor,
  na.value = NA_real_, position = "bottom")

scale_y_time(name = waiver(), breaks = waiver(), minor_breaks = waiver(),
  labels = waiver(), limits = NULL, expand = waiver(), oob = censor,
  na.value = NA_real_, position = "left")
}
\arguments{
\item{name}{The name of the scale. Used as axis or legend title. If
\code{NULL}, the default, the name of the scale is taken from the first
mapping used for that aesthetic.}

\item{breaks}{One of: \itemize{
  \item \code{NULL} for no breaks
  \item \code{waiver()} for the default breaks computed by the
    transformation object
  \item A numeric vector of positions
  \item A function that takes the limits as input and returns breaks
    as output
}}

\item{date_breaks}{A string giving the distance between breaks like "2
weeks", or "10 years". If both \code{breaks} and \code{date_breaks} are
specified, \code{date_breaks} wins.}

\item{labels}{One of: \itemize{
  \item \code{NULL} for no labels
  \item \code{waiver()} for the default labels computed by the
    transformation object
  \item A character vector giving labels (must be same length as \code{breaks})
  \item A function that takes the breaks as input and returns labels
    as output
}}

\item{date_labels}{A string giving the formatting specification for the
labels. Codes are defined in \code{\link{strftime}}. If both \code{labels}
and \code{date_labels} are specified, \code{date_labels} wins.}

\item{minor_breaks}{One of: \itemize{
  \item \code{NULL} for no minor breaks
  \item \code{waiver()} for the default breaks (one minor break between
    each major break)
  \item A numeric vector of positions
  \item A function that given the limits returns a vector of minor breaks.
}}

\item{date_minor_breaks}{A string giving the distance between minor breaks
like "2 weeks", or "10 years". If both \code{minor_breaks} and
\code{date_minor_breaks} are specified, \code{date_minor_breaks} wins.}

\item{limits}{A numeric vector of length two providing limits of the scale.
Use \code{NA} to refer to the existing minimum or maximum.}

\item{expand}{A numeric vector of length two giving multiplicative and
additive expansion constants. These constants ensure that the data is
placed some distance away from the axes. The defaults are
\code{c(0.05, 0)} for continuous variables, and \code{c(0, 0.6)} for
discrete variables.}

\item{position}{The position of the axis. "left" or "right" for vertical
scales, "top" or "bottom" for horizontal scales}

\item{timezone}{The timezone to use for display on the axes. The default
(\code{NULL}) uses the timezone encoded in the data.}

\item{oob}{Function that handles limits outside of the scale limits
(out of bounds). The default replaces out of bounds values with NA.}

\item{na.value}{Missing values will be replaced with this value.}
}
\description{
These are the default scales for the three date/time class. These will
usually be added automatically. To override manually, use
\code{scale_*_date} for dates (class \code{Date}),
\code{scale_*_datetime} for datetimes (class \code{POSIXct}), and
\code{scale_*_time} for times (class \code{hms}).
}
\examples{
last_month <- Sys.Date() - 0:29
df <- data.frame(
  date = last_month,
  price = runif(30)
)
base <- ggplot(df, aes(date, price)) +
  geom_line()

# The date scale will attempt to pick sensible defaults for
# major and minor tick marks. Override with date_breaks, date_labels
# date_minor_breaks arguments.
base + scale_x_date(date_labels = "\%b \%d")
base + scale_x_date(date_breaks = "1 week", date_labels = "\%W")
base + scale_x_date(date_minor_breaks = "1 day")

# Set limits
base + scale_x_date(limits = c(Sys.Date() - 7, NA))
}
\seealso{
Other position scales: \code{\link{scale_x_continuous}},
  \code{\link{scale_x_discrete}}
}
