% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale-gradient.r, R/zxx.r
\name{scale_colour_gradient}
\alias{scale_colour_gradient}
\alias{scale_fill_gradient}
\alias{scale_colour_gradient2}
\alias{scale_fill_gradient2}
\alias{scale_colour_gradientn}
\alias{scale_fill_gradientn}
\alias{scale_colour_datetime}
\alias{scale_colour_date}
\alias{scale_fill_datetime}
\alias{scale_fill_date}
\alias{scale_color_continuous}
\alias{scale_color_gradient}
\alias{scale_color_gradient2}
\alias{scale_color_gradientn}
\title{Gradient colour scales}
\usage{
scale_colour_gradient(..., low = "#132B43", high = "#56B1F7",
  space = "Lab", na.value = "grey50", guide = "colourbar",
  aesthetics = "colour")

scale_fill_gradient(..., low = "#132B43", high = "#56B1F7",
  space = "Lab", na.value = "grey50", guide = "colourbar",
  aesthetics = "fill")

scale_colour_gradient2(..., low = muted("red"), mid = "white",
  high = muted("blue"), midpoint = 0, space = "Lab",
  na.value = "grey50", guide = "colourbar", aesthetics = "colour")

scale_fill_gradient2(..., low = muted("red"), mid = "white",
  high = muted("blue"), midpoint = 0, space = "Lab",
  na.value = "grey50", guide = "colourbar", aesthetics = "fill")

scale_colour_gradientn(..., colours, values = NULL, space = "Lab",
  na.value = "grey50", guide = "colourbar", aesthetics = "colour",
  colors)

scale_fill_gradientn(..., colours, values = NULL, space = "Lab",
  na.value = "grey50", guide = "colourbar", aesthetics = "fill",
  colors)
}
\arguments{
\item{...}{Arguments passed on to \code{continuous_scale}
\describe{
  \item{scale_name}{The name of the scale}
  \item{palette}{A palette function that when called with a numeric vector with
values between 0 and 1 returns the corresponding values in the range the
scale maps to.}
  \item{name}{The name of the scale. Used as the axis or legend title. If
\code{waiver()}, the default, the name of the scale is taken from the first
mapping used for that aesthetic. If \code{NULL}, the legend title will be
omitted.}
  \item{breaks}{One of:
\itemize{
\item \code{NULL} for no breaks
\item \code{waiver()} for the default breaks computed by the
transformation object
\item A numeric vector of positions
\item A function that takes the limits as input and returns breaks
as output
}}
  \item{minor_breaks}{One of:
\itemize{
\item \code{NULL} for no minor breaks
\item \code{waiver()} for the default breaks (one minor break between
each major break)
\item A numeric vector of positions
\item A function that given the limits returns a vector of minor breaks.
}}
  \item{labels}{One of:
\itemize{
\item \code{NULL} for no labels
\item \code{waiver()} for the default labels computed by the
transformation object
\item A character vector giving labels (must be same length as \code{breaks})
\item A function that takes the breaks as input and returns labels
as output
}}
  \item{limits}{A numeric vector of length two providing limits of the scale.
Use \code{NA} to refer to the existing minimum or maximum.}
  \item{rescaler}{Used by diverging and n colour gradients
(i.e. \code{\link[=scale_colour_gradient2]{scale_colour_gradient2()}}, \code{\link[=scale_colour_gradientn]{scale_colour_gradientn()}}).
A function used to scale the input values to the range [0, 1].}
  \item{oob}{Function that handles limits outside of the scale limits
(out of bounds). The default replaces out of bounds values with \code{NA}.}
  \item{trans}{Either the name of a transformation object, or the
object itself. Built-in transformations include "asn", "atanh",
"boxcox", "exp", "identity", "log", "log10", "log1p", "log2",
"logit", "probability", "probit", "reciprocal", "reverse" and "sqrt".

A transformation object bundles together a transform, its inverse,
and methods for generating breaks and labels. Transformation objects
are defined in the scales package, and are called \code{name_trans}, e.g.
\code{\link[scales:boxcox_trans]{scales::boxcox_trans()}}. You can create your own
transformation with \code{\link[scales:trans_new]{scales::trans_new()}}.}
  \item{position}{The position of the axis. "left" or "right" for vertical
scales, "top" or "bottom" for horizontal scales}
  \item{super}{The super class to use for the constructed scale}
  \item{expand}{Vector of range expansion constants used to add some
padding around the data, to ensure that they are placed some distance
away from the axes. Use the convenience function \code{\link[=expand_scale]{expand_scale()}}
to generate the values for the \code{expand} argument. The defaults are to
expand the scale by 5\% on each side for continuous variables, and by
0.6 units on each side for discrete variables.}
}}

\item{low, high}{Colours for low and high ends of the gradient.}

\item{space}{colour space in which to calculate gradient. Must be "Lab" -
other values are deprecated.}

\item{na.value}{Colour to use for missing values}

\item{guide}{Type of legend. Use \code{"colourbar"} for continuous
colour bar, or \code{"legend"} for discrete colour legend.}

\item{aesthetics}{Character string or vector of character strings listing the
name(s) of the aesthetic(s) that this scale works with. This can be useful, for
example, to apply colour settings to the \code{colour} and \code{fill} aesthetics at the
same time, via \code{aesthetics = c("colour", "fill")}.}

\item{mid}{colour for mid point}

\item{midpoint}{The midpoint (in data value) of the diverging scale.
Defaults to 0.}

\item{colours, colors}{Vector of colours to use for n-colour gradient.}

\item{values}{if colours should not be evenly positioned along the gradient
this vector gives the position (between 0 and 1) for each colour in the
\code{colours} vector. See \code{\link[=rescale]{rescale()}} for a convenience function
to map an arbitrary range to between 0 and 1.}
}
\description{
\code{scale_*_gradient} creates a two colour gradient (low-high),
\code{scale_*_gradient2} creates a diverging colour gradient (low-mid-high),
\code{scale_*_gradientn} creates a n-colour gradient.
}
\details{
Default colours are generated with \pkg{munsell} and
\code{mnsl(c("2.5PB 2/4", "2.5PB 7/10"))}. Generally, for continuous
colour scales you want to keep hue constant, but vary chroma and
luminance. The \pkg{munsell} package makes this easy to do using the
Munsell colour system.
}
\examples{
df <- data.frame(
  x = runif(100),
  y = runif(100),
  z1 = rnorm(100),
  z2 = abs(rnorm(100))
)

# Default colour scale colours from light blue to dark blue
ggplot(df, aes(x, y)) +
  geom_point(aes(colour = z2))

# For diverging colour scales use gradient2
ggplot(df, aes(x, y)) +
  geom_point(aes(colour = z1)) +
  scale_colour_gradient2()

# Use your own colour scale with gradientn
ggplot(df, aes(x, y)) +
  geom_point(aes(colour = z1)) +
  scale_colour_gradientn(colours = terrain.colors(10))

# Equivalent fill scales do the same job for the fill aesthetic
ggplot(faithfuld, aes(waiting, eruptions)) +
  geom_raster(aes(fill = density)) +
  scale_fill_gradientn(colours = terrain.colors(10))

# Adjust colour choices with low and high
ggplot(df, aes(x, y)) +
  geom_point(aes(colour = z2)) +
  scale_colour_gradient(low = "white", high = "black")
# Avoid red-green colour contrasts because ~10\% of men have difficulty
# seeing them
}
\seealso{
\code{\link[scales:seq_gradient_pal]{scales::seq_gradient_pal()}} for details on underlying
palette

Other colour scales: \code{\link{scale_alpha}},
  \code{\link{scale_colour_brewer}},
  \code{\link{scale_colour_grey}},
  \code{\link{scale_colour_hue}},
  \code{\link{scale_colour_viridis_d}}
}
\concept{colour scales}
