% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom-jitter.r
\name{geom_jitter}
\alias{geom_jitter}
\title{Jittered points}
\usage{
geom_jitter(mapping = NULL, data = NULL, stat = "identity",
  position = "jitter", ..., width = NULL, height = NULL,
  na.rm = FALSE, show.legend = NA, inherit.aes = TRUE)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[=aes]{aes()}} or
\code{\link[=aes_]{aes_()}}. If specified and \code{inherit.aes = TRUE} (the
default), it is combined with the default mapping at the top level of the
plot. You must supply \code{mapping} if there is no plot mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[=ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[=fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data.}

\item{stat}{The statistical transformation to use on the data for this
layer, as a string.}

\item{position}{Position adjustment, either as a string, or the result of
a call to a position adjustment function.}

\item{...}{Other arguments passed on to \code{\link[=layer]{layer()}}. These are
often aesthetics, used to set an aesthetic to a fixed value, like
\code{colour = "red"} or \code{size = 3}. They may also be parameters
to the paired geom/stat.}

\item{width}{Amount of vertical and horizontal jitter. The jitter
is added in both positive and negative directions, so the total spread
is twice the value specified here.

If omitted, defaults to 40\% of the resolution of the data: this means the
jitter values will occupy 80\% of the implied bins. Categorical data
is aligned on the integers, so a width or height of 0.5 will spread the
data so it's not possible to see the distinction between the categories.}

\item{height}{Amount of vertical and horizontal jitter. The jitter
is added in both positive and negative directions, so the total spread
is twice the value specified here.

If omitted, defaults to 40\% of the resolution of the data: this means the
jitter values will occupy 80\% of the implied bins. Categorical data
is aligned on the integers, so a width or height of 0.5 will spread the
data so it's not possible to see the distinction between the categories.}

\item{na.rm}{If \code{FALSE}, the default, missing values are removed with
a warning. If \code{TRUE}, missing values are silently removed.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[=borders]{borders()}}.}
}
\description{
The jitter geom is a convenient shortcut for
\code{geom_point(position = "jitter")}. It adds a small amount of random
variation to the location of each point, and is a useful way of handling
overplotting caused by discreteness in smaller datasets.
}
\section{Aesthetics}{

\code{geom_point()} understands the following aesthetics (required aesthetics are in bold):
\itemize{
\item \strong{\code{x}}
\item \strong{\code{y}}
\item \code{alpha}
\item \code{colour}
\item \code{fill}
\item \code{group}
\item \code{shape}
\item \code{size}
\item \code{stroke}
}
Learn more about setting these aesthetics in \code{vignette("ggplot2-specs")}.
}

\examples{
p <- ggplot(mpg, aes(cyl, hwy))
p + geom_point()
p + geom_jitter()

# Add aesthetic mappings
p + geom_jitter(aes(colour = class))

# Use smaller width/height to emphasise categories
ggplot(mpg, aes(cyl, hwy)) + geom_jitter()
ggplot(mpg, aes(cyl, hwy)) + geom_jitter(width = 0.25)

# Use larger width/height to completely smooth away discreteness
ggplot(mpg, aes(cty, hwy)) + geom_jitter()
ggplot(mpg, aes(cty, hwy)) + geom_jitter(width = 0.5, height = 0.5)
}
\seealso{
\code{\link[=geom_point]{geom_point()}} for regular, unjittered points,
\code{\link[=geom_boxplot]{geom_boxplot()}} for another way of looking at the conditional
distribution of a variable
}
