% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat-fit-broom.R
\name{stat_fit_augment}
\alias{stat_fit_augment}
\title{Return the data augmented with fitted values and statistics.}
\usage{
stat_fit_augment(mapping = NULL, data = NULL, geom = "smooth",
  method = "lm", method.args = list(formula = y ~ x),
  augment.args = list(), level = 0.95, y.out = ".fitted",
  position = "identity", na.rm = FALSE, show.legend = FALSE,
  inherit.aes = TRUE, ...)
}
\arguments{
\item{mapping}{The aesthetic mapping, usually constructed with
\code{\link[ggplot2]{aes}} or \code{\link[ggplot2]{aes_string}}. Only needs
to be set at the layer level if you are overriding the plot defaults.}

\item{data}{A layer specific dataset - only needed if you want to override
the plot defaults.}

\item{geom}{The geometric object to use display the data}

\item{method}{character.}

\item{method.args}{list of arguments to pass to \code{method}.}

\item{augment.args}{list of arguments to pass to \code{broom:augment}.}

\item{level}{numeric Level of confidence interval to use (0.95 by default)}

\item{y.out}{character (or numeric) index to column to return as \code{y}.}

\item{position}{The position adjustment to use for overlapping points on this
layer}

\item{na.rm}{logical indicating whether NA values should be stripped
before the computation proceeds.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped. \code{FALSE}
never includes, and \code{TRUE} always includes.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics, rather
than combining with them. This is most useful for helper functions that
define both data and aesthetics and shouldn't inherit behaviour from the
default plot specification, e.g. \code{\link[ggplot2]{borders}}.}

\item{...}{other arguments passed on to \code{\link[ggplot2]{layer}}. This
can include aesthetics whose values you want to set, not map. See
\code{\link[ggplot2]{layer}} for more details.}
}
\description{
\code{stat_fit_augment} fits a model and returns the data augmented with
information from the fitted model, using package 'broom'.
}
\note{
The statistics \code{stat_fit_augment} and
  \code{stat_fit_augment_panel} at the moment accepts only \code{methods}
  that accept formulas under any formal parameter name and a \code{data}
  argument. Use \code{ggplot2::stat_smooth()} instead of
  \code{stat_fit_augment} in production code if the additional features are
  not needed. At the moment \code{stat_fit_augment} is under development and
  may change.
}
\section{Computed variables}{

  The output of \code{\link[broom]{augment}} is returned as is, except for
  \code{y} which is set based on \code{y.out} and \code{y.observed} which
  preserves the \code{y} returned by the \code{broom::augment} methods.
}

