% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lmodel2-util.R
\name{predict.lmodel2}
\alias{predict.lmodel2}
\title{Model Predictions}
\usage{
\method{predict}{lmodel2}(
  object,
  method = "MA",
  newdata = NULL,
  interval = c("none", "confidence"),
  level = 0.95,
  ...
)
}
\arguments{
\item{object}{a fitted model object.}

\item{method}{character One of the methods available in \code{object}.}

\item{newdata}{An optional data frame in which to look for variables with
which to predict. If omitted, the fitted values are used.}

\item{interval}{Type of interval calculation.}

\item{level}{the confidence level required. Currently only 0.95 accepted.}

\item{...}{ignored by this method.}
}
\value{
If \code{interval = "none"} a numeric vector is returned, while if
  \code{interval = "confidence"} a data frame with columns \code{fit},
  \code{lwr} and \code{upr} is returned.
}
\description{
\code{predict} is a generic function for predictions from the results of
  various model fitting functions. \code{predict.lmodel2} is the method
  for model fit objects of class \code{"lmodel2"}.
}
\details{
Function \code{lmodel2()} from package 'lmodel2' returns a fitted
  model object of class \code{"lmodel2"} which differs from that returned by
  \code{lm()}. Here we implement a \code{predict()} method for objects of
  this class. It differs from the generic method and that for \code{lm}
  objects in having an additional formal parameter \code{method} that must be
  used to select which of the methods supported by \code{lmodel2()} are to be
  used in the prediction. The returned object is similar in its structure to
  that returned by \code{predict.lm()} but lacking names or rownames.
}
\seealso{
\code{\link[lmodel2]{lmodel2}}
}
