% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tableau.R
\name{scale_colour_gradient2_tableau}
\alias{scale_colour_gradient2_tableau}
\alias{scale_fill_gradient2_tableau}
\alias{scale_color_gradient2_tableau}
\title{Tableau diverging colour scales (continuous)}
\usage{
scale_colour_gradient2_tableau(palette = "Red-Blue", ..., space = "rgb",
  na.value = "grey50", guide = "colourbar")

scale_fill_gradient2_tableau(palette = "Red-Blue", ..., space = "rgb",
  na.value = "grey50", guide = "colourbar")

scale_color_gradient2_tableau(palette = "Red-Blue", ..., space = "rgb",
  na.value = "grey50", guide = "colourbar")
}
\arguments{
\item{palette}{Palette name. See \code{ggthemes_data$tableau$divergent}.}

\item{...}{Other arguments passed on to \code{\link{discrete_scale}}
to control name, limits, breaks, labels and so forth.}

\item{space}{Colour space in which to calculate gradient.}

\item{na.value}{Colour to use for missing values}

\item{guide}{Type of legend. Use \code{'colourbar'} for continuous
colour bar, or \code{'legend'} for discrete colour legend.}
}
\description{
Tableau diverging colour scales (continuous)
}
\examples{
library("ggplot2")
df <- data.frame(
x = runif(100),
y = runif(100),
z1 = rnorm(100),
z2 = abs(rnorm(100))
)
p <- ggplot(df, aes(x, y)) + geom_point(aes(colour = z2))

p + scale_colour_gradient2_tableau()
p + scale_colour_gradient2_tableau('Orange-Blue')
p + scale_colour_gradient2_tableau('Temperature')
}
\seealso{
Other colour tableau: \code{\link{scale_colour_gradient_tableau}},
  \code{\link{scale_colour_tableau}},
  \code{\link{tableau_color_pal}},
  \code{\link{tableau_div_gradient_pal}},
  \code{\link{tableau_seq_gradient_pal}}
}
