% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/base.R
\name{theme_par}
\alias{theme_par}
\title{Theme which uses the current \sQuote{base} graphics parameter values
from \code{\link{par}}.
Not all \code{par} parameters, are supported, and not all are relevant to
\pkg{ggplot2} themes.}
\usage{
theme_par(base_size = par()$ps, base_family = par()$family)
}
\arguments{
\item{base_size}{base font size}

\item{base_family}{base font family}
}
\description{
Currently this theme uses the values of the parameters:
\code{"code"}, "\code{"ps"}", \code{"code"} \code{"family"}, \code{"fg"},
\code{"bg"}, \code{"adj"}, \code{"font"}, \code{"cex.axis"},
\code{"cex.lab"}, \code{"cex.main"}, \code{"cex.sub"}, \code{"col.axis"},
\code{"col.lab"}, \code{"col.main"}, \code{"col.sub"}, \code{"font"},
\code{"font.axis"}, \code{"font.lab"}, \code{"font.main"},
\code{"font.sub"}, \code{"las"}, \code{"lend"},
\code{"lheight"}, \code{"lty"}, \code{"mar"}, \code{"ps"}, \code{"tcl"},
\code{"tck"}, \code{"xaxt"}, \code{"yaxt"}.
}
\details{
This theme does not translate the base graphics perfectly, so the graphs
produced by it will not be identical to those produced by base graphics,
most notably in the spacing of the margins.
}
\examples{
library("ggplot2")

p <- ggplot(mtcars) +
  geom_point(aes(x = wt, y = mpg, colour = factor(gear))) +
  facet_wrap(~am)

p + theme_par()

# theme changes with respect to values of par
par(font = 2, col.lab = "red", fg = "white", bg = "black")
p + theme_par()
}
\seealso{
Other themes: \code{\link{theme_base}},
  \code{\link{theme_foundation}},
  \code{\link{theme_igray}}, \code{\link{theme_solid}}
}
\concept{themes}
