% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/ggvis.R
\name{ggvis}
\alias{ggvis}
\title{Visualise a data set with a ggvis graphic.}
\usage{
ggvis(data = NULL, ..., env = parent.frame())
}
\arguments{
\item{data}{A data object.}

\item{...}{Property mappings. If not named, the first two mappings are
taken to be \code{x} and \code{y}. Common properties are \code{x},
\code{y}, \code{stroke}, \code{fill}, \code{opacity}, \code{shape}}

\item{env}{Environment in which to evaluate properties.}
}
\description{
\code{ggvis} is used to turn a dataset into a visualisation, setting up
default mappings between variables in the dataset and visual properties.
Nothing will be displayed until you add additional layers.
}
\examples{
# If you don't supply a layer, ggvis uses layer_guess() to guess at
# an appropriate type:
mtcars \%>\% ggvis(~mpg, ~wt)
mtcars \%>\% ggvis(~mpg, ~wt, fill = ~cyl)
mtcars \%>\% ggvis(~mpg, ~wt, fill := "red")
mtcars \%>\% ggvis(~mpg)

# ggvis has a functional interface: every ggvis function takes a ggvis
# an input and returns a modified ggvis as output.
layer_points(ggvis(mtcars, ~mpg, ~wt))

# To make working with this interface more natural, ggvis imports the
# pipe operator from magrittr. x \%>\% f(y) is equivalent to f(x, y) so
# we can rewrite the previous command as
mtcars \%>\% ggvis(~mpg, ~wt) \%>\% layer_points()

# For more complicated plots, add a line break after \%>\%
mtcars \%>\%
  ggvis(~mpg, ~wt) \%>\%
  layer_points() \%>\%
  layer_smooths()
}

