% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/gist_create.R
\name{gist_create}
\alias{gist_create}
\title{Create a gist}
\usage{
gist_create(files = NULL, description = "", public = TRUE,
  browse = TRUE, code = NULL, filename = "code.R", knit = FALSE,
  knitopts = list(), ...)
}
\arguments{
\item{files}{Files to upload}

\item{description}{(character) Brief description of gist (optional)}

\item{public}{(logical) Whether gist is public (default: TRUE)}

\item{browse}{(logical) To open newly create gist in default browser (default: TRUE)}

\item{code}{Pass in any set of code. This can be a single R object, or many lines of code
wrapped in quotes, then curly brackets (see examples below).}

\item{filename}{Name of the file to create, only used if \code{code} parameter is used. Default
to \code{code.R}}

\item{knit}{(logical) Knit code before posting as a gist? Knitting done with
\code{link[knitr]{knit}}}

\item{knitopts}{(list) List of variables passed on to \code{link[knitr]{knit}}}

\item{...}{Further args passed on to \code{link[httr]{POST}}}
}
\description{
Create a gist
}
\examples{
\dontrun{
gist_create(files="~/stuff.md", description='a new cool gist')
gist_create(files=c("~/spocc_sp.Rmd","~/spocc_sp.md"), description='spocc demo files')

# include any code by passing to the code parameter
gist_create(code={'
x <- letters
numbers <- runif(10)
numbers
'})

# or include results if you want, and change the filename in this case
gist_create(code={'
x <- letters
numbers <- runif(8)
numbers

[1] 0.3229318 0.5933054 0.7778408 0.3898947 0.1309717 0.7501378 0.3206379 0.3379005
'}, filename="my_cool_code.R")

# Knit an .Rmd file before posting as a gist
file <- system.file("examples", "stuff.Rmd", package = "gistr")
gist_create(file, description='a new cool gist', knit=TRUE)

file <- "~/alm_othersources.Rmd"
gist_create(file, description='a new cool gist', knit=TRUE)

# Knit code input before posting as a gist
gist_create(code={'
```{r}
x <- letters
(numbers <- runif(8))
```
'}, knit=TRUE)

library('httr')
base <- "http://pelias.mapzen.com/search"
res <- GET(base, query = list(input = 'coffee shop', lat = 45.5, lon = -122.6))
json <- content(res, as = "text")
gist_create(code = json, filename = "pelias_test.geojson")
}
}

