% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/message.R
\name{attachment}
\alias{attachment}
\title{Retrieve an attachment to a message}
\usage{
attachment(id, message_id, user_id = "me")
}
\arguments{
\item{id}{id of the attachment}

\item{message_id}{id of the parent message}

\item{user_id}{gmail user_id to access, special value of 'me' indicates the authenticated user.}
}
\description{
Function to retrieve an attachment to a message by id of the attachment
and message.  To save the attachment use \code{\link{save_attachment}}.
}
\examples{
\dontrun{
my_attachment = attachment('a32e324b', '12345')
save attachment to a file
save_attachment(my_attachment, 'photo.jpg')
}
}
\references{
\url{https://developers.google.com/gmail/api/v1/reference/users/messages/attachments/get}
}
\seealso{
Other message: \code{\link{delete_message}},
  \code{\link{import_message}},
  \code{\link{insert_message}}, \code{\link{messages}},
  \code{\link{message}}, \code{\link{modify_message}},
  \code{\link{save_attachments}},
  \code{\link{save_attachment}},
  \code{\link{send_message}}, \code{\link{trash_message}},
  \code{\link{untrash_message}}
}

