% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/googleAuthR_shiny.R
\name{gar_shiny_getToken}
\alias{gar_shiny_getToken}
\title{Returns the authentication Token.}
\usage{
gar_shiny_getToken(code, redirect.uri,
  client.id = getOption("googleAuthR.webapp.client_id"),
  client.secret = getOption("googleAuthR.webapp.client_secret"))
}
\arguments{
\item{code}{The code returned from a successful Google authentication.}

\item{redirect.uri}{Where a user will go after authentication,
from \code{gar_shiny_getUrl(session)}}

\item{client.id}{From the Google API console.}

\item{client.secret}{From the Google API console.}
}
\value{
A list including the token needed for Google API requests.
}
\description{
Once a user browses to ShinyGetTokenURL and is redirected back with request
gar_shiny_getToken takes that code and returns a token needed for Google APIs
Uses the same client.id and client.secret as ShinyGetTokenURL.
}
\seealso{
Other shiny auth functions: \code{\link{authReturnCode}};
  \code{\link{createCode}};
  \code{\link{gar_shiny_getAuthUrl}};
  \code{\link{gar_shiny_getUrl}};
  \code{\link{loginOutput}};
  \code{\link{reactiveAccessToken}};
  \code{\link{renderLogin}}; \code{\link{with_shiny}}
}
\keyword{internal}

