% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/permissions.R
\name{gs_perm_add}
\alias{gs_perm_add}
\title{Add a permission to a spreadsheet}
\usage{
gs_perm_add(ss, email = NULL, type = c("anyone", "user", "domain", "group"),
  role = c("reader", "writer", "owner"), commenter = FALSE,
  with_link = TRUE, send_email = TRUE, verbose = TRUE)
}
\arguments{
\item{ss}{a registered Google spreadsheet, i.e. a \code{\link{googlesheet}}
object}

\item{type}{The value "user", "group", "domain" or "anyone".}

\item{role}{role}

\item{commenter}{logical}

\item{with_link}{logical; whether the link is required for this permission}

\item{send_email}{logical; do you want to send notification emails when
sharing to users or groups?}

\item{verbose}{logical; do you want informative messages?}
}
\value{
a tbl_df with information about the newly added permission.
}
\description{
An email will be sent automatically to the entity to notify them of the
permission.
}
\details{
Commenting is allowed by default for "owners" and "writers".
Set commenter = TRUE if you want "readers" to be able to comment.
}
\examples{
\dontrun{
foo <- gs_new("foo")
gs_perm_ls(foo)
# Add anyone as a reader:
gs_perm_add(foo, type = "anyone", role = "reader")
gs_perm_ls(foo)
gs_delete(foo)
}
}
\keyword{internal}

