% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gs_upload.R
\name{gs_upload}
\alias{gs_upload}
\title{Upload a file and convert it to a Google Sheet}
\usage{
gs_upload(file, sheet_title = NULL, verbose = TRUE)
}
\arguments{
\item{file}{path to the file to upload}

\item{sheet_title}{the title of the spreadsheet; optional, if not specified
then the name of the file will be used}

\item{verbose}{logical; do you want informative messages?}
}
\description{
Google supports the following file types to be converted to a Google
spreadsheet: .xls, .xlsx, .csv, .tsv, .txt, .tab, .xlsm, .xlt, .xltx, .xltm,
.ods. The newly uploaded file will appear in your Google Sheets home screen.
This function calls the
\href{https://developers.google.com/drive/v2/reference/}{Google Drive API}.
}
\examples{
\dontrun{
write.csv(head(iris, 5), "iris.csv", row.names = FALSE)
iris_ss <- gs_upload("iris.csv")
iris_ss
gs_read(iris_ss)
file.remove("iris.csv")
gs_delete(iris_ss)
}

}

