% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gs_ws.R
\name{gs_ws_delete}
\alias{gs_ws_delete}
\title{Delete a worksheet from a spreadsheet}
\usage{
gs_ws_delete(ss, ws = 1, verbose = TRUE)
}
\arguments{
\item{ss}{a registered Google spreadsheet, i.e. a \code{\link{googlesheet}}
object}

\item{ws}{positive integer or character string specifying index or title,
respectively, of the worksheet}

\item{verbose}{logical; do you want informative messages?}
}
\value{
a \code{\link{googlesheet}} object
}
\description{
The worksheet and all of its contents will be removed from the spreadsheet.
}
\examples{
\dontrun{
gap_ss <- gs_copy(gs_gap(), to = "gap_copy")
gs_ws_ls(gap_ss)
gap_ss <- gs_ws_new(gap_ss, "new_stuff")
gap_ss <- gs_edit_cells(gap_ss, "new_stuff", input = head(iris), trim = TRUE)
gap_ss
gap_ss <- gs_ws_delete(gap_ss, "new_stuff")
gs_ws_ls(gap_ss)
gap_ss <- gs_ws_delete(gap_ss, ws = 3)
gs_ws_ls(gap_ss)
gs_delete(gap_ss)
}

}
