% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gs_cell-specification.R
\name{cell-specification}
\alias{cell-specification}
\alias{cell_limits}
\alias{cell_rows}
\alias{cell_cols}
\alias{anchored}
\title{Specify cells for reading or writing}
\description{
If you aren't targetting all the cells in a worksheet, you can request that
\code{googlesheets} limit a read or write operation to a specific rectangle
of cells. Any function that offers this flexibility will have a \code{range}
argument. The simplest usage is to specify an Excel-like cell range, such as
\code{range = "D12:F15"} or \code{range = "R1C12:R6C15"}. The cell rectangle
can be specified in various other ways, using helper functions. In all cases,
cell range processing is handled by the \code{\link[=cellranger]{cellranger}}
package, where you can find full documentation for the functions used in the
examples below.
}
\examples{
\dontrun{
gs_gap() \%>\% gs_read(ws = 2, range = "A1:D8")
gs_gap() \%>\% gs_read(ws = "Europe", range = cell_rows(1:4))
gs_gap() \%>\% gs_read(ws = "Europe", range = cell_rows(100:103),
                     col_names = FALSE)
gs_gap() \%>\% gs_read(ws = "Africa", range = cell_cols(1:4))
gs_gap() \%>\% gs_read(ws = "Asia", range = cell_limits(c(1, 5), c(4, NA)))
}

}
\seealso{
The \code{\link[=cellranger]{cellranger}} package has full
  documentation on cell specification and offers additional functions for
  manipulating "A1:D10" style spreadsheet ranges. Here are the most relevant:
  \itemize{
    \item \code{\link[cellranger]{cell_limits}}
    \item \code{\link[cellranger]{cell_rows}}
    \item \code{\link[cellranger]{cell_cols}}
    \item \code{\link[cellranger]{anchored}}
  }
  See a full list of functions in the \code{\link{cellranger}} index.
}
