% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gd_drive_user.R
\name{gd_user}
\alias{gd_user}
\alias{gs_user}
\title{Retrieve information about the current Google user}
\usage{
gd_user(full = FALSE, verbose = TRUE)

gs_user(full = FALSE, verbose = TRUE)
}
\arguments{
\item{full}{Logical, indicating whether to return selected (\code{FALSE},
the default) or full (\code{TRUE}) user information.}

\item{verbose}{logical; do you want informative messages?}
}
\value{
an object of S3 class `drive_user`, which is just a list
}
\description{
Retrieve information about the Google user that has authorized
\code{\link{googlesheets}} to call the Drive and Sheets APIs on their behalf.
As long as \code{full = FALSE} (the default), only the most useful subset of
the information available from
\href{https://developers.google.com/drive/v2/reference/about/get}{the "about"
endpoint} of the Drive API is returned. This is also the information exposed
in the print method:
}
\details{
\itemize{
\item User's display name
\item User's email
\item Date-time of user info lookup
\item User's permission ID
\item User's root folder ID
}

When \code{full = TRUE}, all information provided by the API is returned.
}
\examples{
\dontrun{
## these are synonyms: gd = Google Drive, gs = Google Sheets
gd_user()
gs_user()
}

}
\seealso{
Other auth functions: \code{\link{gs_auth}},
  \code{\link{gs_deauth}}
}
\concept{auth functions}
