% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/google_map_urls.R
\name{google_map_search}
\alias{google_map_search}
\title{Google Map Search}
\usage{
google_map_search(query, place_id = NULL)
}
\arguments{
\item{query}{string or vector of lat/lon coordinates (in that order)}

\item{place_id}{a Google place id (\url{https://developers.google.com/places/web-service/place-id}).}
}
\description{
Opens a Google Map in a browser with the result of the specified search query.
}
\details{
If both parameters are given, the \code{query} is only used if Google Maps cannot
find the \code{place_id}.
}
\note{
There is no need for an api key
}
\examples{
\dontrun{

google_map_search("Melbourne, Victoria")

google_map_search("Restaruants")

## Melbourne Cricket Ground
google_map_search(c(-37.81997, 144.9834), place_id = "ChIJgWIaV5VC1moR-bKgR9ZfV2M")

## Without the place_id, no additional place inforamtion is displayed on the map
google_map_search(c(-37.81997, 144.9834))

}

}
