% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/manipulate_layout.R
\name{layout_manipulate}
\alias{layout_manipulate}
\alias{layout_rotate}
\alias{layout_mirror}
\title{Manipulate layout}
\usage{
layout_rotate(xy, angle)

layout_mirror(xy, axis = "vertical")
}
\arguments{
\item{xy}{graph layout}

\item{angle}{angle for rotation}

\item{axis}{mirror horizontal or vertical}
}
\value{
manipulated layout
}
\description{
functions to manipulate an existing layout
}
\details{
These functions are mostly useful for deterministic layouts such as \link{layout_with_stress}
}
\examples{
library(igraph)
g <- sample_gnp(50,0.3)

xy <- layout_with_stress(g)

#rotate 90 degrees
xy <- layout_rotate(xy,90)

# flip horizontally
xy <- layout_mirror(xy,"horizontal")

}
\author{
David Schoch
}
