% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tools.R
\name{find_peak}
\alias{find_peak}
\title{Find peaks}
\usage{
find_peak(dat, npeaks = NULL, breaks = round(length(dat) * 0.1),
  check = FALSE, method = "density")
}
\arguments{
\item{dat}{Vector, containing theta values for one sample and chromosome.}

\item{npeaks}{Integer, Number of peaks to be detected.}

\item{breaks}{Integer, Number of breaks for the histogram.}

\item{check}{Logical, if TRUE it is checked if the central peak is approximately in the middle of the two other peaks.
If the data has not heterozygotes, the third peak might be very close to one of the homozygous peaks.
In that case the peak is set to the middle of the other two peaks.}

\item{method}{Character, "mixture", "density" or "histogram".
Defines which method is used to transform the data into a distribution.}
}
\description{
Find peaks
}
\keyword{internal}

