# This file is auto-generated by h2o-3/h2o-bindings/bin/gen_R.py
# Copyright 2016 H2O.ai;  Apache License Version 2.0 (see LICENSE for details) 
#'
# -------------------------- klime -------------------------- #
#' 
#' Fits a k-LIME model on predictions produced by a ML model. Provides explanations/reason codes.
#' 
#' @param x A vector containing the names or indices of the predictor variables to use in building the model.
#'        If x is missing,then all columns except y are used.
#' @param y The name of the response variable in the model.If the data does not contain a header, this is the first column
#'        index, and increasing from left to right. (The response must be either an integer or a
#'        categorical variable).
#' @param model_id Destination id for this model; auto-generated if not specified.
#' @param training_frame Id of the training data frame (Not required, to allow initial validation of model parameters).
#' @param max_k Maximum number of clusters to be considered. Defaults to 20.
#' @param estimate_k \code{Logical}. Automatically determine the number of clusters in an unsupervised manner. Defaults to TRUE.
#' @param alpha Balance between L1 and L2 regularization. Use alpha=0 to switch off L1 variable selection. Defaults to 0.5.
#' @param min_cluster_size Required minimum cluster size to build a local regression model, smaller clusters will use a global model.
#'        Defaults to 20.
#' @param seed Seed for random numbers (affects certain parts of the algo that are stochastic and those might or might not be enabled by default)
#'        Defaults to -1 (time-based random number).
#' @export
h2o.klime <- function(training_frame, x, y,
                      model_id = NULL,
                      max_k = 20,
                      estimate_k = TRUE,
                      alpha = 0.5,
                      min_cluster_size = 20,
                      seed = -1
                      ) 
{
  #If x is missing, then assume user wants to use all columns as features.
  if(missing(x)){
     if(is.numeric(y)){
         x <- setdiff(col(training_frame),y)
     }else{
         x <- setdiff(colnames(training_frame),y)
     }
  }

  # Required args: training_frame
  if( missing(training_frame) ) stop("argument 'training_frame' is missing, with no default")
  # Training_frame must be a key or an H2OFrame object
  if (!is.H2OFrame(training_frame))
     tryCatch(training_frame <- h2o.getFrame(training_frame),
           error = function(err) {
             stop("argument 'training_frame' must be a valid H2OFrame or key")
           })
  # Parameter list to send to model builder
  parms <- list()
  parms$training_frame <- training_frame
  args <- .verify_dataxy(training_frame, x, y)
  parms$response_column <- args$y
  parms$ignored_columns <- args$x_ignore
  if (!missing(model_id))
    parms$model_id <- model_id
  if (!missing(max_k))
    parms$max_k <- max_k
  if (!missing(estimate_k))
    parms$estimate_k <- estimate_k
  if (!missing(alpha))
    parms$alpha <- alpha
  if (!missing(min_cluster_size))
    parms$min_cluster_size <- min_cluster_size
  if (!missing(seed))
    parms$seed <- seed
  # Error check and build model
  .h2o.modelJob('klime', parms, h2oRestApiVersion=3) 
}
