% Generated by roxygen2 (4.0.2): do not edit by hand
\name{h2o.transform}
\alias{h2o.transform}
\alias{h2o.within}
\title{Transform Columns in an H2OFrame Object.}
\usage{
h2o.transform(`_data`, ...)

h2o.within(data, expr, ...)
}
\arguments{
\item{_data,data}{An \linkS4class{H2OFrame} object.}

\item{...}{For \code{transform} method, column transformations in the form \code{tag=value}.}

\item{expr}{For \code{within} method, column transformations specified as an expression.}
}
\description{
Functions that facilitate column transformations of an \linkS4class{H2OFrame} object.


}
\examples{
\donttest{
library(h2o)
localH2O <- h2o.init()
iris.hex <- as.h2o(iris, localH2O)
transformed1 <- transform(iris.hex,
                          Sepal.Ratio = Sepal.Length / Sepal.Width,
                          Petal.Ratio = Petal.Length / Petal.Width )
transformed1
transformed2 <- within(iris.hex,
                       {Sepal.Product <- Sepal.Length * Sepal.Width
                        Petal.Product <- Petal.Length * Petal.Width
                        Sepal.Petal.Ratio <- Sepal.Product / Petal.Product
                        Sepal.Length <- Sepal.Width <- NULL
                        Petal.Length <- Petal.Width <- NULL
                        })
transformed2
}
}
\seealso{
\code{\link[base]{transform}}, \code{\link[base]{within}} for the base R methods.
}

