# This file is auto-generated by h2o-3/h2o-bindings/bin/gen_R.py
# Copyright 2016 H2O.ai;  Apache License Version 2.0 (see LICENSE for details) 
#'
# -------------------------- Deep Water - Neural Network -------------------------- #
#' 
#' Build a Deep Learning model using multiple native GPU backends
#' 
#' Builds a deep neural network on an H2OFrame containing various data sources.
#' 
#' @param x (Optional) A vector containing the names or indices of the predictor variables to use in building the model.
#'        If x is missing, then all columns except y are used.
#' @param y The name or column index of the response variable in the data. The response must be either a numeric or a
#'        categorical/factor variable. If the response is numeric, then a regression model will be trained, otherwise it will train a classification model.
#' @param model_id Destination id for this model; auto-generated if not specified.
#' @param checkpoint Model checkpoint to resume training with.
#' @param autoencoder \code{Logical}. Auto-Encoder. Defaults to FALSE.
#' @param training_frame Id of the training data frame.
#' @param validation_frame Id of the validation data frame.
#' @param nfolds Number of folds for K-fold cross-validation (0 to disable or >= 2). Defaults to 0.
#' @param balance_classes \code{Logical}. Balance training data class counts via over/under-sampling (for imbalanced data). Defaults to
#'        FALSE.
#' @param max_after_balance_size Maximum relative size of the training data after balancing class counts (can be less than 1.0). Requires
#'        balance_classes. Defaults to 5.0.
#' @param class_sampling_factors Desired over/under-sampling ratios per class (in lexicographic order). If not specified, sampling factors will
#'        be automatically computed to obtain class balance during training. Requires balance_classes.
#' @param keep_cross_validation_models \code{Logical}. Whether to keep the cross-validation models. Defaults to TRUE.
#' @param keep_cross_validation_predictions \code{Logical}. Whether to keep the predictions of the cross-validation models. Defaults to FALSE.
#' @param keep_cross_validation_fold_assignment \code{Logical}. Whether to keep the cross-validation fold assignment. Defaults to FALSE.
#' @param fold_assignment Cross-validation fold assignment scheme, if fold_column is not specified. The 'Stratified' option will
#'        stratify the folds based on the response variable, for classification problems. Must be one of: "AUTO",
#'        "Random", "Modulo", "Stratified". Defaults to AUTO.
#' @param fold_column Column with cross-validation fold index assignment per observation.
#' @param offset_column Offset column. This will be added to the combination of columns before applying the link function.
#' @param weights_column Column with observation weights. Giving some observation a weight of zero is equivalent to excluding it from
#'        the dataset; giving an observation a relative weight of 2 is equivalent to repeating that row twice. Negative
#'        weights are not allowed. Note: Weights are per-row observation weights and do not increase the size of the
#'        data frame. This is typically the number of times a row is repeated, but non-integer values are supported as
#'        well. During training, rows with higher weights matter more, due to the larger loss function pre-factor.
#' @param score_each_iteration \code{Logical}. Whether to score during each iteration of model training. Defaults to FALSE.
#' @param categorical_encoding Encoding scheme for categorical features Must be one of: "AUTO", "Enum", "OneHotInternal", "OneHotExplicit",
#'        "Binary", "Eigen", "LabelEncoder", "SortByResponse", "EnumLimited". Defaults to AUTO.
#' @param overwrite_with_best_model \code{Logical}. If enabled, override the final model with the best model found during training. Defaults to
#'        TRUE.
#' @param epochs How many times the dataset should be iterated (streamed), can be fractional. Defaults to 10.
#' @param train_samples_per_iteration Number of training samples (globally) per MapReduce iteration. Special values are 0: one epoch, -1: all
#'        available data (e.g., replicated training data), -2: automatic. Defaults to -2.
#' @param target_ratio_comm_to_comp Target ratio of communication overhead to computation. Only for multi-node operation and
#'        train_samples_per_iteration = -2 (auto-tuning). Defaults to 0.05.
#' @param seed Seed for random numbers (affects certain parts of the algo that are stochastic and those might or might not be enabled by default)
#'        Note: only reproducible when running single threaded.
#'        Defaults to -1 (time-based random number).
#' @param standardize \code{Logical}. If enabled, automatically standardize the data. If disabled, the user must provide properly
#'        scaled input data. Defaults to TRUE.
#' @param learning_rate Learning rate (higher => less stable, lower => slower convergence). Defaults to 0.001.
#' @param learning_rate_annealing Learning rate annealing: rate / (1 + rate_annealing * samples). Defaults to 1e-06.
#' @param momentum_start Initial momentum at the beginning of training (try 0.5). Defaults to 0.9.
#' @param momentum_ramp Number of training samples for which momentum increases. Defaults to 10000.
#' @param momentum_stable Final momentum after the ramp is over (try 0.99). Defaults to 0.9.
#' @param distribution Distribution function Must be one of: "AUTO", "bernoulli", "multinomial", "gaussian", "poisson", "gamma",
#'        "tweedie", "laplace", "quantile", "huber". Defaults to AUTO.
#' @param score_interval Shortest time interval (in seconds) between model scoring. Defaults to 5.
#' @param score_training_samples Number of training set samples for scoring (0 for all). Defaults to 10000.
#' @param score_validation_samples Number of validation set samples for scoring (0 for all). Defaults to 0.
#' @param score_duty_cycle Maximum duty cycle fraction for scoring (lower: more training, higher: more scoring). Defaults to 0.1.
#' @param classification_stop Stopping criterion for classification error fraction on training data (-1 to disable). Defaults to 0.
#' @param regression_stop Stopping criterion for regression error (MSE) on training data (-1 to disable). Defaults to 0.
#' @param stopping_rounds Early stopping based on convergence of stopping_metric. Stop if simple moving average of length k of the
#'        stopping_metric does not improve for k:=stopping_rounds scoring events (0 to disable) Defaults to 5.
#' @param stopping_metric Metric to use for early stopping (AUTO: logloss for classification, deviance for regression) Must be one of:
#'        "AUTO", "deviance", "logloss", "MSE", "RMSE", "MAE", "RMSLE", "AUC", "lift_top_group", "misclassification",
#'        "mean_per_class_error", "custom", "custom_increasing". Defaults to AUTO.
#' @param stopping_tolerance Relative tolerance for metric-based stopping criterion (stop if relative improvement is not at least this
#'        much) Defaults to 0.
#' @param max_runtime_secs Maximum allowed runtime in seconds for model training. Use 0 to disable. Defaults to 0.
#' @param ignore_const_cols \code{Logical}. Ignore constant columns. Defaults to TRUE.
#' @param shuffle_training_data \code{Logical}. Enable global shuffling of training data. Defaults to TRUE.
#' @param mini_batch_size Mini-batch size (smaller leads to better fit, larger can speed up and generalize better). Defaults to 32.
#' @param clip_gradient Clip gradients once their absolute value is larger than this value. Defaults to 10.
#' @param network Network architecture. Must be one of: "auto", "user", "lenet", "alexnet", "vgg", "googlenet", "inception_bn",
#'        "resnet". Defaults to auto.
#' @param backend Deep Learning Backend. Must be one of: "mxnet", "caffe", "tensorflow". Defaults to mxnet.
#' @param image_shape Width and height of image. Defaults to [0, 0].
#' @param channels Number of (color) channels. Defaults to 3.
#' @param sparse \code{Logical}. Sparse data handling (more efficient for data with lots of 0 values). Defaults to FALSE.
#' @param gpu \code{Logical}. Whether to use a GPU (if available). Defaults to TRUE.
#' @param device_id Device IDs (which GPUs to use). Defaults to [0].
#' @param cache_data \code{Logical}. Whether to cache the data in memory (automatically disabled if data size is too large).
#'        Defaults to TRUE.
#' @param network_definition_file Path of file containing network definition (graph, architecture).
#' @param network_parameters_file Path of file containing network (initial) parameters (weights, biases).
#' @param mean_image_file Path of file containing the mean image data for data normalization.
#' @param export_native_parameters_prefix Path (prefix) where to export the native model parameters after every iteration.
#' @param activation Activation function. Only used if no user-defined network architecture file is provided, and only for
#'        problem_type=dataset. Must be one of: "Rectifier", "Tanh".
#' @param hidden Hidden layer sizes (e.g. [200, 200]). Only used if no user-defined network architecture file is provided, and
#'        only for problem_type=dataset.
#' @param input_dropout_ratio Input layer dropout ratio (can improve generalization, try 0.1 or 0.2). Defaults to 0.
#' @param hidden_dropout_ratios Hidden layer dropout ratios (can improve generalization), specify one value per hidden layer, defaults to 0.5.
#' @param problem_type Problem type, auto-detected by default. If set to image, the H2OFrame must contain a string column containing
#'        the path (URI or URL) to the images in the first column. If set to text, the H2OFrame must contain a string
#'        column containing the text in the first column. If set to dataset, Deep Water behaves just like any other H2O
#'        Model and builds a model on the provided H2OFrame (non-String columns). Must be one of: "auto", "image",
#'        "dataset". Defaults to auto.
#' @param export_checkpoints_dir Automatically export generated models to this directory.
#' @export
h2o.deepwater <- function(x, y, training_frame,
                          model_id = NULL,
                          checkpoint = NULL,
                          autoencoder = FALSE,
                          validation_frame = NULL,
                          nfolds = 0,
                          balance_classes = FALSE,
                          max_after_balance_size = 5.0,
                          class_sampling_factors = NULL,
                          keep_cross_validation_models = TRUE,
                          keep_cross_validation_predictions = FALSE,
                          keep_cross_validation_fold_assignment = FALSE,
                          fold_assignment = c("AUTO", "Random", "Modulo", "Stratified"),
                          fold_column = NULL,
                          offset_column = NULL,
                          weights_column = NULL,
                          score_each_iteration = FALSE,
                          categorical_encoding = c("AUTO", "Enum", "OneHotInternal", "OneHotExplicit", "Binary", "Eigen", "LabelEncoder", "SortByResponse", "EnumLimited"),
                          overwrite_with_best_model = TRUE,
                          epochs = 10,
                          train_samples_per_iteration = -2,
                          target_ratio_comm_to_comp = 0.05,
                          seed = -1,
                          standardize = TRUE,
                          learning_rate = 0.001,
                          learning_rate_annealing = 1e-06,
                          momentum_start = 0.9,
                          momentum_ramp = 10000,
                          momentum_stable = 0.9,
                          distribution = c("AUTO", "bernoulli", "multinomial", "gaussian", "poisson", "gamma", "tweedie", "laplace", "quantile", "huber"),
                          score_interval = 5,
                          score_training_samples = 10000,
                          score_validation_samples = 0,
                          score_duty_cycle = 0.1,
                          classification_stop = 0,
                          regression_stop = 0,
                          stopping_rounds = 5,
                          stopping_metric = c("AUTO", "deviance", "logloss", "MSE", "RMSE", "MAE", "RMSLE", "AUC", "lift_top_group", "misclassification", "mean_per_class_error", "custom", "custom_increasing"),
                          stopping_tolerance = 0,
                          max_runtime_secs = 0,
                          ignore_const_cols = TRUE,
                          shuffle_training_data = TRUE,
                          mini_batch_size = 32,
                          clip_gradient = 10,
                          network = c("auto", "user", "lenet", "alexnet", "vgg", "googlenet", "inception_bn", "resnet"),
                          backend = c("mxnet", "caffe", "tensorflow"),
                          image_shape = c(0, 0),
                          channels = 3,
                          sparse = FALSE,
                          gpu = TRUE,
                          device_id = c(0),
                          cache_data = TRUE,
                          network_definition_file = NULL,
                          network_parameters_file = NULL,
                          mean_image_file = NULL,
                          export_native_parameters_prefix = NULL,
                          activation = c("Rectifier", "Tanh"),
                          hidden = NULL,
                          input_dropout_ratio = 0,
                          hidden_dropout_ratios = NULL,
                          problem_type = c("auto", "image", "dataset"),
                          export_checkpoints_dir = NULL
                          ) 
{
  # If x is missing, then assume user wants to use all columns as features.
  if (missing(x)) {
     if (is.numeric(y)) {
         x <- setdiff(col(training_frame), y)
     } else {
         x <- setdiff(colnames(training_frame), y)
     }
  }

  # Required args: training_frame
  if (missing(training_frame)) stop("argument 'training_frame' is missing, with no default")
  # Training_frame must be a key or an H2OFrame object
  if (!is.H2OFrame(training_frame))
     tryCatch(training_frame <- h2o.getFrame(training_frame),
           error = function(err) {
             stop("argument 'training_frame' must be a valid H2OFrame or key")
           })
  # Validation_frame must be a key or an H2OFrame object
  if (!is.null(validation_frame)) {
     if (!is.H2OFrame(validation_frame))
         tryCatch(validation_frame <- h2o.getFrame(validation_frame),
             error = function(err) {
                 stop("argument 'validation_frame' must be a valid H2OFrame or key")
             })
  }
  # Parameter list to send to model builder
  parms <- list()
  parms$training_frame <- training_frame
  args <- .verify_dataxy(training_frame, x, y, autoencoder)
  if( !missing(offset_column) && !is.null(offset_column))  args$x_ignore <- args$x_ignore[!( offset_column == args$x_ignore )]
  if( !missing(weights_column) && !is.null(weights_column)) args$x_ignore <- args$x_ignore[!( weights_column == args$x_ignore )]
  if( !missing(fold_column) && !is.null(fold_column)) args$x_ignore <- args$x_ignore[!( fold_column == args$x_ignore )]
  parms$ignored_columns <- args$x_ignore
  parms$response_column <- args$y

  if (!missing(model_id))
    parms$model_id <- model_id
  if (!missing(checkpoint))
    parms$checkpoint <- checkpoint
  if (!missing(autoencoder))
    parms$autoencoder <- autoencoder
  if (!missing(validation_frame))
    parms$validation_frame <- validation_frame
  if (!missing(nfolds))
    parms$nfolds <- nfolds
  if (!missing(balance_classes))
    parms$balance_classes <- balance_classes
  if (!missing(max_after_balance_size))
    parms$max_after_balance_size <- max_after_balance_size
  if (!missing(class_sampling_factors))
    parms$class_sampling_factors <- class_sampling_factors
  if (!missing(keep_cross_validation_models))
    parms$keep_cross_validation_models <- keep_cross_validation_models
  if (!missing(keep_cross_validation_predictions))
    parms$keep_cross_validation_predictions <- keep_cross_validation_predictions
  if (!missing(keep_cross_validation_fold_assignment))
    parms$keep_cross_validation_fold_assignment <- keep_cross_validation_fold_assignment
  if (!missing(fold_assignment))
    parms$fold_assignment <- fold_assignment
  if (!missing(fold_column))
    parms$fold_column <- fold_column
  if (!missing(offset_column))
    parms$offset_column <- offset_column
  if (!missing(weights_column))
    parms$weights_column <- weights_column
  if (!missing(score_each_iteration))
    parms$score_each_iteration <- score_each_iteration
  if (!missing(categorical_encoding))
    parms$categorical_encoding <- categorical_encoding
  if (!missing(overwrite_with_best_model))
    parms$overwrite_with_best_model <- overwrite_with_best_model
  if (!missing(epochs))
    parms$epochs <- epochs
  if (!missing(train_samples_per_iteration))
    parms$train_samples_per_iteration <- train_samples_per_iteration
  if (!missing(target_ratio_comm_to_comp))
    parms$target_ratio_comm_to_comp <- target_ratio_comm_to_comp
  if (!missing(seed))
    parms$seed <- seed
  if (!missing(standardize))
    parms$standardize <- standardize
  if (!missing(learning_rate))
    parms$learning_rate <- learning_rate
  if (!missing(learning_rate_annealing))
    parms$learning_rate_annealing <- learning_rate_annealing
  if (!missing(momentum_start))
    parms$momentum_start <- momentum_start
  if (!missing(momentum_ramp))
    parms$momentum_ramp <- momentum_ramp
  if (!missing(momentum_stable))
    parms$momentum_stable <- momentum_stable
  if (!missing(distribution))
    parms$distribution <- distribution
  if (!missing(score_interval))
    parms$score_interval <- score_interval
  if (!missing(score_training_samples))
    parms$score_training_samples <- score_training_samples
  if (!missing(score_validation_samples))
    parms$score_validation_samples <- score_validation_samples
  if (!missing(score_duty_cycle))
    parms$score_duty_cycle <- score_duty_cycle
  if (!missing(classification_stop))
    parms$classification_stop <- classification_stop
  if (!missing(regression_stop))
    parms$regression_stop <- regression_stop
  if (!missing(stopping_rounds))
    parms$stopping_rounds <- stopping_rounds
  if (!missing(stopping_metric))
    parms$stopping_metric <- stopping_metric
  if (!missing(stopping_tolerance))
    parms$stopping_tolerance <- stopping_tolerance
  if (!missing(max_runtime_secs))
    parms$max_runtime_secs <- max_runtime_secs
  if (!missing(ignore_const_cols))
    parms$ignore_const_cols <- ignore_const_cols
  if (!missing(shuffle_training_data))
    parms$shuffle_training_data <- shuffle_training_data
  if (!missing(mini_batch_size))
    parms$mini_batch_size <- mini_batch_size
  if (!missing(clip_gradient))
    parms$clip_gradient <- clip_gradient
  if (!missing(network))
    parms$network <- network
  if (!missing(backend))
    parms$backend <- backend
  if (!missing(image_shape))
    parms$image_shape <- image_shape
  if (!missing(channels))
    parms$channels <- channels
  if (!missing(sparse))
    parms$sparse <- sparse
  if (!missing(gpu))
    parms$gpu <- gpu
  if (!missing(device_id))
    parms$device_id <- device_id
  if (!missing(cache_data))
    parms$cache_data <- cache_data
  if (!missing(network_definition_file))
    parms$network_definition_file <- network_definition_file
  if (!missing(network_parameters_file))
    parms$network_parameters_file <- network_parameters_file
  if (!missing(mean_image_file))
    parms$mean_image_file <- mean_image_file
  if (!missing(export_native_parameters_prefix))
    parms$export_native_parameters_prefix <- export_native_parameters_prefix
  if (!missing(activation))
    parms$activation <- activation
  if (!missing(hidden))
    parms$hidden <- hidden
  if (!missing(input_dropout_ratio))
    parms$input_dropout_ratio <- input_dropout_ratio
  if (!missing(hidden_dropout_ratios))
    parms$hidden_dropout_ratios <- hidden_dropout_ratios
  if (!missing(problem_type))
    parms$problem_type <- problem_type
  if (!missing(export_checkpoints_dir))
    parms$export_checkpoints_dir <- export_checkpoints_dir
  # Error check and build model
  .h2o.modelJob('deepwater', parms, h2oRestApiVersion = 3) 
}

#' Determines whether Deep Water is available
#'
#' Ask the H2O server whether a Deep Water model can be built. (Depends on availability of native backends.)
#' Returns TRUE if a Deep Water model can be built, or FALSE otherwise.
#' @param h2oRestApiVersion (Optional) Specific version of the REST API to use.
#' @export
h2o.deepwater.available <- function(h2oRestApiVersion = .h2o.__REST_API_VERSION) {
res <- .h2o.__remoteSend(method = "GET",
h2oRestApiVersion = h2oRestApiVersion,
page = .h2o.__MODEL_BUILDERS("deepwater"))
visibility <- res$model_builders[["deepwater"]][["visibility"]]
if (visibility == "Experimental") {
print("Cannot build a Deep Water model - no backend found.")
available <- FALSE
} else {
available <- TRUE
}
return(available)
}

