% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frame.R
\name{h2o.runif}
\alias{h2o.runif}
\title{Produce a Vector of Random Uniform Numbers}
\usage{
h2o.runif(x, seed = -1)
}
\arguments{
\item{x}{An H2OFrame object.}

\item{seed}{A random seed used to generate draws from the uniform distribution.}
}
\value{
A vector of random, uniformly distributed numbers. The elements are between 0 and 1.
}
\description{
Creates a vector of random uniform numbers equal in length to the length of the specified H2O
dataset.
}
\examples{
\donttest{
library(h2o)
h2o.init()
prostate_path <- system.file("extdata", "prostate.csv", package = "h2o")
prostate <- h2o.importFile(path = prostate_path)
s <- h2o.runif(prostate)
summary(s)

prostate_train <- prostate[s <= 0.8,]
prostate_test <- prostate[s > 0.8,]
nrow(prostate_train) + nrow(prostate_test)
}
}
