% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.R
\name{h2o.cross_validation_predictions}
\alias{h2o.cross_validation_predictions}
\title{Retrieve the cross-validation predictions}
\usage{
h2o.cross_validation_predictions(object)
}
\arguments{
\item{object}{An \linkS4class{H2OModel} object.}
}
\value{
Returns a list of H2OFrame objects
}
\description{
Retrieve the cross-validation predictions
}
\examples{
\dontrun{
library(h2o)
h2o.init()

f <- "https://s3.amazonaws.com/h2o-public-test-data/smalldata/junit/cars_20mpg.csv"
cars <- h2o.importFile(f)
cars["economy_20mpg"] <- as.factor(cars["economy_20mpg"])
predictors <- c("displacement","power","weight","acceleration","year")
response <- "economy_20mpg"
cars.split <- h2o.splitFrame(data = cars,ratios = 0.8, seed = 1234)
train <- cars.split[[1]]
valid <- cars.split[[2]]
cars_gbm <- h2o.gbm(x = predictors, y = response, training_frame = train, 
                    nfolds = 5,  keep_cross_validation_predictions = TRUE, seed = 1234)
h2o.cross_validation_predictions(cars_gbm)
}
}
