% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/infogram.R
\name{plot.H2OInfogram}
\alias{plot.H2OInfogram}
\title{Plot an H2O Infogram}
\usage{
\method{plot}{H2OInfogram}(x, ...)
}
\arguments{
\item{x}{A fitted \linkS4class{H2OInfogram} object.}

\item{...}{additional arguments to pass on.}
}
\value{
A ggplot2 object.
}
\description{
Plots the Infogram for an H2OInfogram object.
}
\examples{
\dontrun{
h2o.init()

# Convert iris dataset to an H2OFrame
train <- as.h2o(iris)

# Create and plot infogram
ig <- h2o.infogram(y = "Species", training_frame = train)
plot(ig)

}
}
\seealso{
\code{\link{h2o.infogram}}
}
