% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/hdnom.nomogram.R
\name{hdnom.nomogram}
\alias{hdnom.nomogram}
\title{Nomograms for High-Dimensional Cox models}
\usage{
hdnom.nomogram(object, model.type = c("lasso", "alasso", "flasso", "enet",
  "aenet", "mcp", "mnet", "scad", "snet"), x, time, event, ddist,
  lambda = NULL, pred.at = NULL, fun.at = NULL, funlabel = NULL)
}
\arguments{
\item{object}{Fitted model object.}

\item{model.type}{Fitted model type. Could be one of \code{"lasso"},
\code{"alasso"}, \code{"flasso"}, \code{"enet"}, \code{"aenet"},
\code{"mcp"}, \code{"mnet"}, \code{"scad"}, or \code{"snet"}.}

\item{x}{Matrix of training data used for fitting the model.}

\item{time}{Survival time.
Must be of the same length with the number of rows as \code{x}.}

\item{event}{Status indicator, normally 0 = alive, 1 = dead.
Must be of the same length with the number of rows as \code{x}.}

\item{ddist}{Data frame version of x, made by \code{\link[rms]{datadist}}.}

\item{lambda}{Value of the penalty parameter lambda in
\code{\link[glmnet]{glmnet}} or \code{\link[ncvreg]{ncvsurv}}.
Required except when \code{model.type == "flasso"}.
We will use the selected variables at the provided \code{lambda} to
build the nomogram, and make predictions.
See the example for choosing a proper lambda value extracted
from cross-validation results.}

\item{pred.at}{Time point at which to plot nomogram prediction axis.}

\item{fun.at}{Function values to label on axis.}

\item{funlabel}{Label for \code{fun} axis.}
}
\description{
Nomograms for High-Dimensional Cox models
}
\examples{
library("glmnet")
library("survival")
library("rms")

# Load imputed SMART data
data(smart)
x = as.matrix(smart[, -c(1, 2)])
time = smart$TEVENT
event = smart$EVENT
x.df = as.data.frame(x)
dd = datadist(x.df)
options(datadist = "dd")

# Fit penalized Cox model (lasso penalty) with glmnet
set.seed(1010)
cvfit = cv.glmnet(x, Surv(time, event), family = "cox", nfolds = 10)
fit = glmnet(x, Surv(time, event), family = "cox")

# Generate hdnom.nomogram objects and plot nomogram
nom = hdnom.nomogram(fit, model.type = 'lasso', x, time, event, x.df,
                     lambda = cvfit$lambda.1se, pred.at = 365 * 2,
                     funlabel = "2-Year Overall Survival Probability")

print(nom)
plot(nom)
}

