% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RColorBrewer.R
\name{RColorBrewer_colors}
\alias{RColorBrewer_colors}
\alias{BrBG}
\alias{PiYG}
\alias{PRGn}
\alias{PuOr}
\alias{RdBu}
\alias{RdGy}
\alias{RdYlBu}
\alias{RdYlGn}
\alias{Spectral}
\alias{Blues}
\alias{BuGn}
\alias{BuPu}
\alias{GnBu}
\alias{Greens}
\alias{Greys}
\alias{Oranges}
\alias{OrRd}
\alias{PuBu}
\alias{PuBuGn}
\alias{PuRd}
\alias{Purples}
\alias{RdPu}
\alias{Reds}
\alias{YlGn}
\alias{YlGnBu}
\alias{YlOrBr}
\alias{YlOrRd}
\title{RColorBrewer color Ramp Palette}
\usage{
BrBG(n)

PiYG(n)

PRGn(n)

PuOr(n)

RdBu(n)

RdGy(n)

RdYlBu(n)

RdYlGn(n)

Spectral(n)

Blues(n)

BuGn(n)

BuPu(n)

GnBu(n)

Greens(n)

Greys(n)

Oranges(n)

OrRd(n)

PuBu(n)

PuBuGn(n)

PuRd(n)

Purples(n)

RdPu(n)

Reds(n)

YlGn(n)

YlGnBu(n)

YlOrBr(n)

YlOrRd(n)
}
\arguments{
\item{n}{the number of colors (>= 1) to be in the palette.}
}
\value{
A character vector of color names.
}
\description{
Functions for getting the colors of RColorBrewer (i.e.: \link{brewer.pal}) without the limitation of only 9/11
color values, based on \link{colorRampPalette}.

For sequential palettes this is not essential since we have \link{viridis}. But for diverging palettes
this is quit essential.

The sequential palettes names are
Blues BuGn BuPu GnBu Greens Greys Oranges OrRd PuBu PuBuGn PuRd Purples RdPu Reds YlGn YlGnBu YlOrBr YlOrRd

The diverging palettes are
BrBG PiYG PRGn PuOr RdBu RdGy RdYlBu RdYlGn Spectral
}
\examples{
\dontrun{

library(RColorBrewer)
display.brewer.all(n=11,type="div"); title(main = "Divergent color palette")
display.brewer.all(n=9,type=c("seq")); title(main = "Sequential color palette")

library(heatmaply)
heatmaply(cor(mtcars), colors = PiYG, limits = c(-1,1))
heatmaply(cor(mtcars), colors = RdBu, limits = c(-1,1))

}
}
