% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/states.R
\name{define_state}
\alias{define_state}
\alias{modify.state}
\title{Define a Markov Model State}
\usage{
define_state(...)

\method{modify}{state}(.OBJECT, ..., BEFORE)
}
\arguments{
\item{...}{Name-value pairs of expressions defining state
values.}

\item{.OBJECT}{An object of class \code{state}.}

\item{BEFORE}{character, length 1. Name of state values 
before which new values are to be added.}
}
\value{
An object of class \code{state} (actually a named
  list of \code{lazy} expressions).
}
\description{
Define the values characterising a Markov Model state for
1 cycle.
}
\details{
As with \code{\link{define_parameters}}, state values are defined
sequencially. Later state definition can thus only refer to values
defined earlier.

For the \code{modify} function, existing values are
modified, new values are added at the end by default
if \code{BEFORE} is not specified. Values order
matters since only values defined earlier can be
referenced in later expressions.
}
\examples{

st <- define_state(
  cost = 6453,
  utility = .876
)
st

# this will fail at model evaluation
st_2 <- define_state(
  total_cost = cost_1 + cost_2
)
modify(
  st_2,
  cost_1 = 14,
  cost_2 = 53
)

# use BEFORE instead

modify(
  st_2,
  cost_1 = 14,
  cost_2 = 53,
  BEFORE = "total_cost"
)

}

