% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_define.R
\name{define_model}
\alias{define_model}
\alias{define_model_}
\title{Define a Markov Model}
\usage{
define_model(..., transition_matrix = define_matrix())

define_model_(transition_matrix, states)
}
\arguments{
\item{...}{Object generated by 
\code{\link{define_state}}.}

\item{transition_matrix}{An object generated by 
\code{\link{define_matrix}}.}

\item{states}{List of states, only used by 
\code{define_model_} to avoid using \code{...}.}
}
\value{
An object of class \code{uneval_model} (a list 
  containing the unevaluated parameters, matrix and 
  states).
}
\description{
Combine information on parameters, transition matrix and 
states defined through \code{\link{define_parameters}}, 
\code{\link{define_matrix}} and 
\code{\link{define_state}} respectively.
}
\details{
This function checks whether the objects are compatible 
in the same model (same state names...).
}
\examples{
mat <- define_matrix(
  state_names = c("s1", "s2"),
  1 / c, 1 - 1/ c,
  0, 1
)

s1 <- define_state(
  cost = 234,
  utility = 1
  )
s2 <- define_state(
  cost = 421,
  utility = .5
  )

define_model(
  transition_matrix = mat,
  s1 = s1,
  s2 = s2
)
}

