% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deprecated.R, R/sensitivity_eval.R
\name{run_sensitivity}
\alias{run_dsa}
\alias{run_sensitivity}
\title{Run Sensitivity Analysis}
\usage{
run_sensitivity(model, sensitivity)

run_dsa(model, dsa)
}
\arguments{
\item{model}{An evaluated Markov model.}

\item{sensitivity}{Deprecated, use \code{dsa} instead.}

\item{dsa}{An object returned by 
\code{\link{define_dsa}}.}
}
\value{
A \code{data.frame} with one row per model and 
  parameter value.
}
\description{
Run Sensitivity Analysis
}
\examples{
param <- define_parameters(
  p1 = .5,
  p2 = .2,
  r = .05
)
mod1 <- define_strategy(
  transition = define_transition(
    C, p1,
    p2, C
  ),
  define_state(
    cost = discount(543, r),
    ly = 1
  ),
  define_state(
    cost = discount(432, r),
    ly = .5
  )
)

mod2 <- define_strategy(
  transition = define_transition(
    C, p1,
    p2, C
  ),
  define_state(
    cost = 789,
    ly = 1
  ),
  define_state(
    cost = 456,
    ly = .8
  )
)

res2 <- run_model(
  mod1, mod2,
  parameters = param,
  init = c(100, 0),
  cycles = 10,
  cost = cost,
  effect = ly
)

ds <- define_dsa(
  p1, .1, .9,
  p2, .1, .3,
  r, .05, .1
)
print(ds)

x <- run_dsa(res2, ds)

plot(x, value = "cost")

# can be specified as a function of other parameters


ds2 <- define_dsa(
  p2, p1 - .1, p1 + .1
)

run_dsa(res2, ds2)
}

