% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/heuristics.R
\name{ttbModel}
\alias{ttbModel}
\title{Take The Best}
\usage{
ttbModel(train_data, criterion_col, cols_to_fit, reverse_cues = TRUE,
  fit_name = "ttbModel")
}
\arguments{
\item{train_data}{Training/fitting data as a matrix or data.frame.}

\item{criterion_col}{The index of the colum in train_data that has the
criterion.}

\item{cols_to_fit}{A vector of column indices in train_data, used to fit
the criterion.}

\item{reverse_cues}{Optional parameter to reverse cues as needed.  By
default, the model will reverse the cue values for cues with cue validity
< 0.5, so a cue with validity 0 becomes a cue with validity 1.
Set this to FALSE if you do not want that, i.e. the cue stays validity 0.}

\item{fit_name}{Optional The name other functions can use to label output.
It defaults to the class name.  It is useful to change this to a unique name
if you are making multiple fits, e.g. "ttb1", "ttb2", "ttbNoReverse."}
}
\value{
An object of \code{\link[base]{class}} ttbModel, which can be passed
to a variety of functions to make predictions, e.g.
\code{\link{predictPair}} and \code{\link{percentCorrectList}}.
}
\description{
An implementation of the Take The Best heuristic.
It sorts cues in order of \code{\link{cueValidity}}, making a decision
based on the first cue that discriminates (has differing values on the
two objects).
}
\details{
Cues that are tied in validity are sorted once at fitting time, and that
order is used consistently for all predictions with that model.  But re-
fitting may lead to a different cue order.  (An alternative would be to
randomly re-order on every prediction.)
}
\examples{
# Fit column 1 (y) to columns 2 and 3 (x1 and x2) of train_matrix.
train_matrix <- cbind(y=c(5,4), x1=c(1,0), x2=c(0,0))
ttb <- ttbModel(train_matrix, 1, c(2,3))
# Have ttb predict whether row 1 or 2 has a greater value for y.  The
# output is 1, meaning it predicts row1 is bigger.
predictPair(oneRow(train_matrix, 1), oneRow(train_matrix, 2), ttb)

# Now ask it the reverse-- predict whther row 2 or row 1 is greater.  The
# output is -1, meaning it still predicts row1 is bigger.  (It is a
# symmetric heuristic.)
predictPair(oneRow(train_matrix, 2), oneRow(train_matrix, 1), ttb)

# But this test data results in an incorrect prediction-- that row1 has a
# smaller criterion than row2-- because x1 has a reversed direction.
test_matrix <- cbind(y=c(5,4), x1=c(0,1), x2=c(0,0))
predictPair(oneRow(test_matrix, 1), oneRow(test_matrix, 2), ttb)

}
\references{
Gigerenzer, G. & Goldstein, D. G. (1996). "Reasoning the fast and frugal
 way: Models of bounded rationality". Psychological Review, 103, 650-669.

Wikipedia's entry on
\url{http://en.wikipedia.org/wiki/Take-the-best_heuristic}.
}
\seealso{
\code{\link{cueValidity}} for the metric used to sort cues.

\code{\link{predictPair}} for predicting whether row1 is greater.

\code{\link{predictPairProb}} for predicting the probability row1 is
greater.

\code{\link{percentCorrectList}} for the accuracy of predicting all
row pairs in a matrix or data.frame.
}
